/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.util.ThreadUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;

public class ObjectId
implements Comparable<ObjectId> {
    static final boolean D = false;
    final long _base;
    final int _inc;
    boolean _new;
    private static byte _nextByte = (byte)new Random().nextInt();
    private static short _nextShort = (short)new Random().nextInt();
    private static final String _incLock = new String("ObjectId._incLock");
    private static int _time = (int)(System.currentTimeMillis() / 1000L);
    static final Thread _timeFixer;
    private static final long _machine;
    private static final int _bottomTop;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() < 18) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static ObjectId massageToObjectId(Object o) {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof ObjectId) {
            return (ObjectId)o;
        }
        if (o instanceof String && ObjectId.isValid(s = o.toString())) {
            return new ObjectId(s);
        }
        return null;
    }

    public ObjectId(String s) {
        this(s, false);
    }

    public ObjectId(String s, boolean babble) {
        if (!ObjectId.isValid(s)) {
            throw new IllegalArgumentException("invalid ObjectId [" + s + "]");
        }
        if (babble) {
            int i;
            String baseString = s.substring(0, 16);
            String incString = s.substring(16);
            ByteBuffer buf = ByteBuffer.allocate(24);
            for (i = 0; i < baseString.length() / 2; ++i) {
                buf.put((byte)Integer.parseInt(baseString.substring(i * 2, i * 2 + 2), 16));
            }
            buf.flip();
            this._base = buf.getLong();
            buf.clear();
            for (i = 0; i < incString.length() / 2; ++i) {
                buf.put((byte)Integer.parseInt(incString.substring(i * 2, i * 2 + 2), 16));
            }
            buf.flip();
            this._inc = buf.getInt();
        } else {
            byte[] b = new byte[12];
            for (int i = 0; i < b.length; ++i) {
                b[b.length - (i + 1)] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
            }
            ByteBuffer bb = ByteBuffer.wrap(b);
            this._inc = bb.getInt();
            this._base = bb.getLong();
        }
        this._new = false;
    }

    ObjectId(long base, int inc) {
        this._base = base;
        this._inc = inc;
        this._new = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId() {
        this._base = (long)_time << 32 | _machine;
        String string = _incLock;
        synchronized (string) {
            if (_nextShort == Short.MAX_VALUE) {
                _nextByte = (byte)(_nextByte + 1);
            }
            int myb = _nextByte << 16 & 0xFF0000;
            short s = _nextShort;
            _nextShort = (short)(s + 1);
            int myi = s & 0xFFFF;
            this._inc = myb | myi;
        }
        this._new = true;
    }

    public int hashCode() {
        return this._inc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        ObjectId other = ObjectId.massageToObjectId(o);
        if (other == null) {
            return false;
        }
        return this._base == other._base && this._inc == other._inc;
    }

    public String toStringBabble() {
        int i;
        String a = Long.toHexString(this._base);
        String b = Integer.toHexString(this._inc);
        StringBuilder buf = new StringBuilder(16);
        for (i = 0; i < 16 - a.length(); ++i) {
            buf.append("0");
        }
        buf.append(a);
        for (i = 0; i < 8 - b.length(); ++i) {
            buf.append("0");
        }
        buf.append(b);
        return buf.toString();
    }

    public String toStringMongod() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this._inc);
        bb.putLong(this._base);
        StringBuilder buf = new StringBuilder(24);
        for (int i = b.length - 1; i >= 0; --i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    static String _pos(String s, int p) {
        return s.substring(p * 2, p * 2 + 2);
    }

    public static String babbleToMongod(String b) {
        int i;
        if (!ObjectId.isValid(b)) {
            throw new IllegalArgumentException("invalid object id: " + b);
        }
        StringBuilder buf = new StringBuilder(24);
        for (i = 7; i >= 0; --i) {
            buf.append(ObjectId._pos(b, i));
        }
        for (i = 11; i >= 8; --i) {
            buf.append(ObjectId._pos(b, i));
        }
        return buf.toString();
    }

    public String toString() {
        return this.toStringMongod();
    }

    @Override
    public int compareTo(ObjectId id) {
        if (id == null) {
            return -1;
        }
        if (id._base == this._base) {
            if (this._inc < id._inc) {
                return -1;
            }
            if (this._inc > id._inc) {
                return 1;
            }
            return 0;
        }
        if (this._base < id._base) {
            return -1;
        }
        if (this._base > id._base) {
            return 1;
        }
        return 0;
    }

    public long getBase() {
        return this._base;
    }

    public int getInc() {
        return this._inc;
    }

    public static void main(String[] args) {
        ObjectId o;
        ObjectId i;
        HashSet<ObjectId> s = new HashSet<ObjectId>();
        do {
            if (s.contains(i = ObjectId.get())) {
                throw new RuntimeException("ObjectId() generated a repeat");
            }
            s.add(i);
        } while (i.equals(o = new ObjectId(i.toString())));
        throw new RuntimeException(o.toString() + " != " + i.toString());
    }

    static {
        try {
            int startTime = (int)(ManagementFactory.getRuntimeMXBean().getStartTime() & 0xFFFFL);
            _bottomTop = (startTime & 0xFF) << 24;
            int machinePiece = (InetAddress.getLocalHost().getHostName().hashCode() & 0xFFFFFF) << 8;
            _machine = (startTime >> 8 | machinePiece) & Integer.MAX_VALUE;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        _timeFixer = new Thread("ObjectId-TimeFixer"){

            @Override
            public void run() {
                while (true) {
                    ThreadUtil.sleep(499L);
                    _time = (int)(System.currentTimeMillis() / 1000L);
                }
            }
        };
        _timeFixer.setDaemon(true);
        _timeFixer.start();
    }
}

