/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBAddress;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class MongoAdmin
extends Mongo {
    protected static final String DB_NAME = "admin";
    protected final DBAddress _usersDBAddress;

    public MongoAdmin() throws UnknownHostException, MongoException {
        this("127.0.0.1");
    }

    public MongoAdmin(String host) throws UnknownHostException, MongoException {
        this(host, 27017);
    }

    public MongoAdmin(String host, int port) throws UnknownHostException, MongoException {
        this(new DBAddress(host, port, DB_NAME));
    }

    public MongoAdmin(DBAddress addr) throws UnknownHostException, MongoException {
        super(addr);
        this._usersDBAddress = addr;
    }

    public List<String> getDatabaseNames() throws MongoException {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        BasicDBObject res = (BasicDBObject)this.command(cmd);
        if (res.getInt("ok", 0) != 1) {
            throw new MongoException("error counting : " + res);
        }
        BasicDBList l = (BasicDBList)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public Mongo getDatabase(String dbName) throws MongoException {
        try {
            DBAddress addr = new DBAddress(this._usersDBAddress._host, this._usersDBAddress._port, dbName);
            return new Mongo(addr);
        }
        catch (UnknownHostException e) {
            throw new MongoException("Error : address is no longer valid", e);
        }
    }

    public void dropDatabase(String dbName) throws MongoException {
        Mongo m = this.getDatabase(dbName);
        m.dropDatabase();
    }
}

