/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.nio.ByteBuffer;

public class DBMessage {
    static int ID = 1;
    static int HEADER_LENGTH = 16;
    final int _len;
    final int _id;
    final int _responseTo;
    final int _operation;
    final ByteBuffer _data;

    DBMessage(int operation, ByteBuffer data) {
        this._id = ID++;
        this._responseTo = 0;
        this._operation = operation;
        this._data = data;
        if (this._data.position() > 0) {
            this._data.flip();
        }
        this._len = HEADER_LENGTH + data.limit();
    }

    DBMessage(ByteBuffer buf, ByteBuffer dataBuffer) {
        this._len = buf.getInt();
        this._id = buf.getInt();
        this._responseTo = buf.getInt();
        this._operation = buf.getInt();
        this._data = dataBuffer;
    }

    void putHeader(ByteBuffer buf) {
        buf.putInt(this._len);
        buf.putInt(this._id);
        buf.putInt(this._responseTo);
        buf.putInt(this._operation);
    }

    ByteBuffer getData() {
        return this._data;
    }

    int dataLen() {
        return this._len - HEADER_LENGTH;
    }
}

