/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.util.Config;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class DBAddress {
    final String _host;
    final int _port;
    final String _name;
    final InetAddress _addr;
    final InetAddress[] _addrs;

    public DBAddress(String urlFormat) throws UnknownHostException {
        DBAddress._check(urlFormat, "urlFormat");
        int idx = urlFormat.indexOf("/");
        if (idx < 0) {
            this._host = DBAddress.defaultHost();
            this._port = DBAddress.defaultPort();
            this._name = DBAddress._fixName(urlFormat);
        } else {
            this._name = DBAddress._fixName(urlFormat.substring(idx + 1).trim());
            if ((idx = (urlFormat = urlFormat.substring(0, idx).trim()).indexOf(":")) < 0) {
                this._host = urlFormat.trim();
                this._port = DBAddress.defaultPort();
            } else {
                this._host = urlFormat.substring(0, idx);
                this._port = Integer.parseInt(urlFormat.substring(idx + 1));
            }
        }
        DBAddress._check(this._host, "host");
        DBAddress._check(this._name, "name");
        this._addrs = DBAddress._getAddress(this._host);
        this._addr = this._addrs[0];
    }

    static String _fixName(String name) {
        name = name.replace('.', '-');
        return name;
    }

    public DBAddress(DBAddress other, String name) throws UnknownHostException {
        this(other._host, other._port, name);
    }

    public DBAddress(String host, String name) throws UnknownHostException {
        this(host, 27017, name);
    }

    public DBAddress(String host, int port, String name) throws UnknownHostException {
        DBAddress._check(host, "host");
        DBAddress._check(name, "name");
        this._host = host.trim();
        this._port = port;
        this._name = name.trim();
        this._addrs = DBAddress._getAddress(this._host);
        this._addr = this._addrs[0];
    }

    public DBAddress(InetAddress addr, int port, String name) {
        if (addr == null) {
            throw new IllegalArgumentException("addr can't be null");
        }
        DBAddress._check(name, "name");
        this._host = addr.getHostName();
        this._port = port;
        this._name = name.trim();
        this._addr = addr;
        this._addrs = new InetAddress[]{addr};
    }

    static void _check(String thing, String name) {
        if (thing == null) {
            throw new NullPointerException(name + " can't be null ");
        }
        if ((thing = thing.trim()).length() == 0) {
            throw new IllegalArgumentException(name + " can't be empty");
        }
    }

    public int hashCode() {
        return this._host.hashCode() + this._port + this._name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DBAddress) {
            DBAddress a = (DBAddress)other;
            return a._port == this._port && a._name.equals(this._name) && a._host.equals(this._host);
        }
        return false;
    }

    public String toString() {
        return this._host + ":" + this._port + "/" + this._name;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this._addr, this._port);
    }

    public boolean sameHost(String host) {
        int idx = host.indexOf(":");
        int port = DBAddress.defaultPort();
        if (idx > 0) {
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        return this._port == port && this._host.equalsIgnoreCase(host);
    }

    boolean isPaired() {
        return this._addrs.length > 1;
    }

    List<DBAddress> getPairedAddresses() {
        if (this._addrs.length != 2) {
            throw new RuntimeException("not paired.  num addressed : " + this._addrs.length);
        }
        ArrayList<DBAddress> l = new ArrayList<DBAddress>();
        for (int i = 0; i < this._addrs.length; ++i) {
            l.add(new DBAddress(this._addrs[i], this._port, this._name));
        }
        return l;
    }

    private static InetAddress[] _getAddress(String host) throws UnknownHostException {
        if (host.toLowerCase().equals("localhost")) {
            return new InetAddress[]{InetAddress.getLocalHost()};
        }
        return InetAddress.getAllByName(host);
    }

    public static String defaultHost() {
        return Config.get().getTryEnvFirst("db_ip", "127.0.0.1");
    }

    public static int defaultPort() {
        return Integer.parseInt(Config.get().getTryEnvFirst("db_port", Integer.toString(27017)));
    }
}

