/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.OrderedSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BasicDBObject
extends HashMap<String, Object>
implements DBObject {
    private final Set<String> _keys = new OrderedSet<String>();
    private boolean _isPartialObject = false;

    public BasicDBObject() {
    }

    public BasicDBObject(String key, Object value) {
        this.put(key, value);
    }

    public BasicDBObject(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(this);
        return m;
    }

    @Override
    public Object removeField(String key) {
        this._keys.remove(key);
        return this.remove(key);
    }

    @Override
    public boolean isPartialObject() {
        return this._isPartialObject;
    }

    @Override
    public boolean containsField(String field) {
        return super.containsKey(field);
    }

    @Override
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public Object get(String key) {
        return super.get(key);
    }

    public int getInt(String key) {
        return ((Number)this.get(key)).intValue();
    }

    public int getInt(String key, int def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).intValue();
    }

    public long getLong(String key) {
        Object foo = this.get(key);
        return ((Number)foo).longValue();
    }

    public String getString(String key) {
        Object foo = this.get(key);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    @Override
    public Object put(String key, Object val) {
        this._keys.add(key);
        return super.put(key, val);
    }

    @Override
    public void putAll(Map m) {
        for (Object k : m.keySet()) {
            this.put(k.toString(), m.get(k));
        }
    }

    @Override
    public void putAll(DBObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public BasicDBObject append(String key, Object val) {
        this._keys.add(key);
        this.put(key, val);
        return this;
    }

    @Override
    public Set<String> keySet() {
        assert (this._keys.size() == this.size());
        return this._keys;
    }

    @Override
    public String toString() {
        return JSON.serialize(this);
    }

    @Override
    public void markAsPartialObject() {
        this._isPartialObject = true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DBObject)) {
            return false;
        }
        DBObject other = (DBObject)o;
        if (!((Object)this._keys).equals(other.keySet())) {
            return false;
        }
        for (String key : this._keys) {
            Object a = this.get(key);
            Object b = other.get(key);
            if (!(a instanceof Number && b instanceof Number ? ((Number)a).doubleValue() != ((Number)b).doubleValue() : !a.equals(b))) continue;
            return false;
        }
        return true;
    }
}

