/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import java.util.UUID;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.config.Configuration;
import org.modelmapper.spi.MappingContext;
import org.testng.Assert;

public class PropertyExtraction {
    public static void main(String ... args) {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PACKAGE_PRIVATE);
        modelMapper.createTypeMap(Order.class, OrderDTO.class).setPostConverter((Converter)new Converter<Order, OrderDTO>(){

            public OrderDTO convert(MappingContext<Order, OrderDTO> context) {
                DeliveryAddress[] deliveryAddress = ((Order)context.getSource()).deliveryAddress;
                ((OrderDTO)context.getDestination()).deliveryAddress_addressId = new Integer[deliveryAddress.length];
                for (int i = 0; i < deliveryAddress.length; ++i) {
                    ((OrderDTO)context.getDestination()).deliveryAddress_addressId[i] = deliveryAddress[i].addressId;
                }
                return (OrderDTO)context.getDestination();
            }
        });
        Order order = new Order();
        order.id = UUID.randomUUID().toString();
        DeliveryAddress da1 = new DeliveryAddress();
        da1.addressId = 123;
        DeliveryAddress da2 = new DeliveryAddress();
        da2.addressId = 456;
        order.deliveryAddress = new DeliveryAddress[]{da1, da2};
        OrderDTO dto = (OrderDTO)modelMapper.map((Object)order, OrderDTO.class);
        Assert.assertEquals((String)dto.id, (String)order.id);
        Assert.assertEquals((Object[])dto.deliveryAddress_addressId, (Object[])new Integer[]{123, 456});
    }

    public static class OrderDTO {
        String id;
        Integer[] deliveryAddress_addressId;
    }

    public static class DeliveryAddress {
        Integer addressId;
    }

    public static class Order {
        String id;
        DeliveryAddress[] deliveryAddress;
    }
}

