/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.modelmapper.config.Configuration;
import org.modelmapper.spi.MappingContext;
import org.testng.Assert;

public class ComplexConversion {
    public static void main(String ... args) throws Exception {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setFieldMatchingEnabled(true).setFieldAccessLevel(Configuration.AccessLevel.PACKAGE_PRIVATE);
        modelMapper.addMappings((PropertyMap)new PropertyMap<Customer, CustomerDTO>(){

            protected void configure() {
                ((CustomerDTO)this.using(new PaymentInfoConverter(true)).map(((Customer)this.source).getInfo())).setBillingInfo(null);
                ((CustomerDTO)this.using(new PaymentInfoConverter(false)).map(((Customer)this.source).getInfo())).setShippingInfo(null);
            }
        });
        PaymentInfo info1 = new PaymentInfo(1, "Billing");
        PaymentInfo info2 = new PaymentInfo(2, "Shipping");
        PaymentInfo info3 = new PaymentInfo(3, "Billing");
        PaymentInfo info4 = new PaymentInfo(4, "Shipping");
        Customer customer = new Customer();
        customer.info = Arrays.asList(info1, info2, info3, info4);
        CustomerDTO dto = (CustomerDTO)modelMapper.map((Object)customer, CustomerDTO.class);
        Assert.assertEquals((int)dto.billingInfo.get((int)0).id, (int)1);
        Assert.assertEquals((int)dto.billingInfo.get((int)1).id, (int)3);
        Assert.assertEquals((int)dto.shippingInfo.get((int)0).id, (int)2);
        Assert.assertEquals((int)dto.shippingInfo.get((int)1).id, (int)4);
    }

    static class PaymentInfoConverter
    implements Converter<List<PaymentInfo>, List<Object>> {
        private boolean billing;

        PaymentInfoConverter(boolean billing) {
            this.billing = billing;
        }

        public List<Object> convert(MappingContext<List<PaymentInfo>, List<Object>> context) {
            ArrayList<PaymentInfo> payments = new ArrayList<PaymentInfo>();
            for (PaymentInfo p : (List)context.getSource()) {
                if (!(!this.billing ^ "Billing".equals(p.type))) continue;
                payments.add(p);
            }
            return (List)context.getMappingEngine().map(context.create(payments, context.getDestinationType()));
        }
    }

    public static class CustomerDTO {
        List<BillingInfoDTO> billingInfo;
        List<ShippingInfoDTO> shippingInfo;

        void setBillingInfo(List<BillingInfoDTO> billingInfo) {
            this.billingInfo = billingInfo;
        }

        void setShippingInfo(List<ShippingInfoDTO> shippingInfo) {
            this.shippingInfo = shippingInfo;
        }
    }

    public static class ShippingInfoDTO {
        int id;
    }

    public static class BillingInfoDTO {
        int id;
    }

    public static class Customer {
        List<PaymentInfo> info;

        List<PaymentInfo> getInfo() {
            return this.info;
        }
    }

    public static class PaymentInfo {
        int id;
        String type;

        PaymentInfo(int id, String type) {
            this.id = id;
            this.type = type;
        }
    }
}

