/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.protobuf;

import com.google.protobuf.BoolValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import java.util.List;
import org.modelmapper.ModelMapper;
import org.modelmapper.Module;
import org.modelmapper.protobuf.MessageToBuilderConverter;
import org.modelmapper.protobuf.ProtobufValueReader;
import org.modelmapper.protobuf.ProtobufValueWriter;
import org.modelmapper.protobuf.primitive.BoolConverters;
import org.modelmapper.protobuf.primitive.DoubleConverters;
import org.modelmapper.protobuf.primitive.IntConverters;
import org.modelmapper.protobuf.primitive.StringConverters;
import org.modelmapper.spi.StrongTypeConditionalConverter;
import org.modelmapper.spi.ValueReader;
import org.modelmapper.spi.ValueWriter;

public class ProtobufModule
implements Module {
    public void setupModule(ModelMapper modelMapper) {
        modelMapper.getConfiguration().addValueReader((ValueReader)new ProtobufValueReader());
        modelMapper.getConfiguration().addValueWriter((ValueWriter)new ProtobufValueWriter(modelMapper));
        List converters = modelMapper.getConfiguration().getConverters();
        converters.add(new MessageToBuilderConverter());
        converters.add(StrongTypeConditionalConverter.wrap(Boolean.class, BoolValue.class, BoolConverters.BOOL_TO_BOOL_VALUE));
        converters.add(StrongTypeConditionalConverter.wrap(BoolValue.class, Boolean.class, BoolConverters.BOOL_VALUE_TO_BOOL));
        converters.add(StrongTypeConditionalConverter.wrap(Boolean.class, BoolValue.Builder.class, BoolConverters.BOOL_TO_BUILDER));
        converters.add(StrongTypeConditionalConverter.wrap(BoolValue.Builder.class, Boolean.class, BoolConverters.BUILDER_TO_BOOL));
        converters.add(StrongTypeConditionalConverter.wrap(Long.class, Int64Value.class, IntConverters.LONG_TO_LONG_VALUE));
        converters.add(StrongTypeConditionalConverter.wrap(Int64Value.class, Long.class, IntConverters.LONG_VALUE_TO_LONG));
        converters.add(StrongTypeConditionalConverter.wrap(Long.class, Int64Value.Builder.class, IntConverters.LONG_TO_BUILDER));
        converters.add(StrongTypeConditionalConverter.wrap(Int64Value.Builder.class, Long.class, IntConverters.BUILDER_TO_LONG));
        converters.add(StrongTypeConditionalConverter.wrap(Integer.class, Int32Value.class, IntConverters.INT_TO_INT_VALUE));
        converters.add(StrongTypeConditionalConverter.wrap(Int32Value.class, Integer.class, IntConverters.INT_VALUE_TO_INT));
        converters.add(StrongTypeConditionalConverter.wrap(Integer.class, Int32Value.Builder.class, IntConverters.INT_TO_BUILDER));
        converters.add(StrongTypeConditionalConverter.wrap(Int32Value.Builder.class, Integer.class, IntConverters.BUILDER_TO_INT));
        converters.add(StrongTypeConditionalConverter.wrap(Double.class, DoubleValue.class, DoubleConverters.DOUBLE_TO_DOUBLE_VALUE));
        converters.add(StrongTypeConditionalConverter.wrap(DoubleValue.class, Double.class, DoubleConverters.DOUBLE_VALUE_TO_DOUBLE));
        converters.add(StrongTypeConditionalConverter.wrap(Double.class, DoubleValue.Builder.class, DoubleConverters.DOUBLE_TO_BUILDER));
        converters.add(StrongTypeConditionalConverter.wrap(DoubleValue.Builder.class, Double.class, DoubleConverters.BUILDER_TO_DOUBLE));
        converters.add(StrongTypeConditionalConverter.wrap(String.class, StringValue.class, StringConverters.STRING_TO_STRING_VALUE));
        converters.add(StrongTypeConditionalConverter.wrap(StringValue.class, String.class, StringConverters.STRING_VALUE_TO_STRING));
        converters.add(StrongTypeConditionalConverter.wrap(String.class, StringValue.Builder.class, StringConverters.STRING_TO_BUILDER));
        converters.add(StrongTypeConditionalConverter.wrap(StringValue.Builder.class, String.class, StringConverters.BUILDER_TO_STRING));
    }
}

