/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.protobuf;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.modelmapper.ModelMapper;
import org.modelmapper.internal.Errors;
import org.modelmapper.protobuf.ProtobufHelper;
import org.modelmapper.spi.ValueWriter;

public class ProtobufValueWriter
implements ValueWriter<Message.Builder> {
    private ModelMapper modelMapper;

    public ProtobufValueWriter(ModelMapper modelMapper) {
        this.modelMapper = modelMapper;
    }

    public void setValue(Message.Builder destination, Object value, String memberName) {
        if (value == null) {
            return;
        }
        try {
            Class<?> destinationType = destination.getClass();
            if (value instanceof Message.Builder) {
                Method method = ProtobufHelper.setterForBuilder(destinationType, memberName);
                method.invoke((Object)destination, value);
            } else if (value instanceof Iterable) {
                Class<?> iterableType = ProtobufHelper.iterableType(destinationType, memberName);
                Method method = ProtobufHelper.adder(destinationType, memberName);
                for (Object element : (Iterable)value) {
                    Object destElement = this.modelMapper.map(element, iterableType);
                    method.invoke((Object)destination, destElement);
                }
            } else {
                Method method = ProtobufHelper.setter(destination.getClass(), memberName);
                method.invoke((Object)destination, value);
            }
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
        }
        catch (IllegalAccessException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
        }
        catch (InvocationTargetException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
        }
    }

    public ValueWriter.Member<Message.Builder> getMember(Class<Message.Builder> destinationType, final String memberName) {
        try {
            Class<?> memberType = ProtobufHelper.fieldType(destinationType, memberName);
            return new ValueWriter.Member<Message.Builder>(memberType){

                public void setValue(Message.Builder destination, Object value) {
                    ProtobufValueWriter.this.setValue(destination, value, memberName);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
    }

    public Collection<String> memberNames(Class<Message.Builder> destinationType) {
        return ProtobufHelper.fields(destinationType);
    }

    public boolean isResolveMembersSupport() {
        return true;
    }
}

