/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.protobuf;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.modelmapper.internal.Errors;
import org.modelmapper.protobuf.ProtobufHelper;
import org.modelmapper.spi.ValueWriter;

public class ProtobufValueWriter
implements ValueWriter<Message.Builder> {
    public void setValue(Message.Builder destination, Object value, String memberName) {
        try {
            if (ProtobufHelper.hasBuilder(destination.getClass(), memberName)) {
                Method method = ProtobufHelper.setterForBuilder(destination.getClass(), memberName);
                method.invoke((Object)destination, value);
            } else {
                Method method = ProtobufHelper.getter(destination.getClass(), memberName);
                method.invoke((Object)destination, value);
            }
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
        catch (IllegalAccessException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
        }
        catch (InvocationTargetException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
        }
    }

    public ValueWriter.Member<Message.Builder> getMember(Class<Message.Builder> destinationType, String memberName) {
        try {
            Class<?> memberType = ProtobufHelper.getter(destinationType, memberName).getReturnType();
            final Method setter = ProtobufHelper.setter(destinationType, memberName);
            return new ValueWriter.Member<Message.Builder>(memberType){

                public void setValue(Message.Builder destination, Object value) {
                    try {
                        if (value != null) {
                            setter.invoke((Object)destination, value);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
                    }
                    catch (InvocationTargetException e) {
                        throw new Errors().addMessage((Throwable)e, "Cannot set the member", new Object[0]).toMappingException();
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
    }

    public Collection<String> memberNames(Class<Message.Builder> destinationType) {
        return ProtobufHelper.fields(destinationType);
    }

    public boolean isResolveMembersSupport() {
        return true;
    }
}

