/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.modelmapper.internal.util.Lists;
import org.modelmapper.spi.ValueReader;

public class JsonNodeValueReader
implements ValueReader<JsonNode> {
    public Object get(JsonNode source, String memberName) {
        JsonNode propertyNode = source.get(memberName);
        if (propertyNode == null) {
            return null;
        }
        switch (propertyNode.getNodeType()) {
            case BOOLEAN: {
                return propertyNode.asBoolean();
            }
            case NUMBER: {
                return propertyNode.numberValue();
            }
            case POJO: {
                return ((POJONode)propertyNode).getPojo();
            }
            case STRING: {
                return propertyNode.asText();
            }
            case BINARY: {
                try {
                    return propertyNode.binaryValue();
                }
                catch (IOException ignore) {
                    return null;
                }
            }
            case NULL: 
            case MISSING: {
                return null;
            }
        }
        return propertyNode;
    }

    public ValueReader.Member<JsonNode> getMember(JsonNode source, String memberName) {
        final Object value = this.get(source, memberName);
        Class type = value != null ? value.getClass() : JsonNode.class;
        return new ValueReader.Member<JsonNode>(type){

            public JsonNode getOrigin() {
                if (value instanceof JsonNode) {
                    return (JsonNode)value;
                }
                return null;
            }

            public Object get(JsonNode source, String memberName) {
                return JsonNodeValueReader.this.get(source, memberName);
            }
        };
    }

    public Collection<String> memberNames(JsonNode source) {
        if (source.isObject()) {
            return Lists.from((Iterator)source.fieldNames());
        }
        return null;
    }

    public String toString() {
        return "Jackson";
    }
}

