/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.modelmapper.internal.Errors;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class CollectionToArrayNodeConverter
implements ConditionalConverter<Collection<Object>, ArrayNode> {
    private ObjectMapper objectMapper;

    public CollectionToArrayNodeConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Collection.class.isAssignableFrom(sourceType) && ArrayNode.class.isAssignableFrom(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    public ArrayNode convert(MappingContext<Collection<Object>, ArrayNode> context) {
        Collection source = (Collection)context.getSource();
        if (source == null) {
            return null;
        }
        ArrayNode destination = context.getDestination() == null ? this.objectMapper.createArrayNode() : (ArrayNode)context.getDestination();
        for (Object sourceElement : source) {
            if (sourceElement != null) {
                destination.add(this.objectMapper.valueToTree(sourceElement));
                continue;
            }
            destination.add((JsonNode)MissingNode.getInstance());
        }
        return destination;
    }

    private void addPrimitiveElement(ArrayNode destination, Object element) {
        Class<?> elementType = element.getClass();
        try {
            Method method = destination.getClass().getMethod("add", elementType);
            method.invoke((Object)destination, element);
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage("Unsupported type: %s", new Object[]{elementType.getName()}).toMappingException();
        }
        catch (IllegalAccessException e) {
            throw new Errors().addMessage("Unable to map Array->Collection", new Object[]{elementType.getName()}).toMappingException();
        }
        catch (InvocationTargetException e) {
            throw new Errors().addMessage("Unable to map Array->Collection", new Object[]{elementType.getName()}).toMappingException();
        }
    }
}

