/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.modelmapper.internal.util.Lists;
import org.modelmapper.spi.ValueReader;

public class JsonNodeValueReader
implements ValueReader<JsonNode> {
    public Object get(JsonNode source, String memberName) {
        JsonNode propertyNode = source.get(memberName);
        if (propertyNode == null) {
            throw null;
        }
        switch (propertyNode.getNodeType()) {
            case BOOLEAN: {
                return propertyNode.asBoolean();
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                return propertyNode.numberValue();
            }
            case POJO: {
                return ((POJONode)propertyNode).getPojo();
            }
            case STRING: {
                return propertyNode.asText();
            }
            case BINARY: {
                try {
                    return propertyNode.binaryValue();
                }
                catch (IOException ignore) {
                    return null;
                }
            }
        }
        return propertyNode;
    }

    public ValueReader.Member<JsonNode> getMember(JsonNode source, String memberName) {
        Object value = this.get(source, memberName);
        if (value == null) {
            return null;
        }
        if (value instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)value;
            if (jsonNode.isMissingNode()) {
                return null;
            }
            if (jsonNode.isContainerNode()) {
                return new ValueReader.Member((ValueReader)this, JsonNode.class, (Object)jsonNode);
            }
            throw new IllegalArgumentException();
        }
        return new ValueReader.Member((ValueReader)this, value.getClass());
    }

    public Collection<String> memberNames(JsonNode source) {
        if (source.isObject()) {
            return Lists.from((Iterator)source.fieldNames());
        }
        return null;
    }

    public String toString() {
        return "Jackson";
    }
}

