/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import joptsimple.internal.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.AbstractClient;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.client.server.ClientException;
import org.mockserver.client.server.ForwardChainExpectation;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;

public class MockServerClient
extends AbstractClient
implements Closeable {
    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        super(host, port, contextPath);
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, TimeToLive.unlimited()));
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, timeToLive));
    }

    public MockServerClient dumpToLog() {
        return this.dumpToLog(null);
    }

    public MockServerClient dumpToLog(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("dumpToLog")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return this;
    }

    public boolean isRunning() {
        return this.isRunning(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")));
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts == 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return this.isRunning(attempts - 1, timeout, timeUnit);
        }
        catch (SocketConnectionException sce) {
            return false;
        }
    }

    public MockServerClient stop() {
        return this.stop(false);
    }

    public MockServerClient stop(boolean ignoreFailure) {
        block4: {
            try {
                this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
                if (this.isRunning()) {
                    for (int i = 0; this.isRunning() && i < 50; ++i) {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                }
            }
            catch (Exception e) {
                if (ignoreFailure) break block4;
                this.logger.warn("Failed to send stop request to MockServer " + e.getMessage());
            }
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public MockServerClient reset() {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this;
    }

    public MockServerClient clear(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return this;
    }

    public MockServerClient clear(HttpRequest httpRequest, TYPE type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return this;
    }

    void sendExpectation(Expectation expectation) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("expectation")).withBody(expectation != null ? this.expectationSerializer.serialize(expectation) : "", Charsets.UTF_8));
        if (httpResponse != null && httpResponse.getStatusCode() != 201) {
            throw new ClientException(this.formatErrorMessage(Character.NEW_LINE + "error: %swhile submitted expectation: %s", httpResponse.getBody() + Character.NEW_LINE, expectation));
        }
    }

    public MockServerClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0 || httpRequests[0] == null) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public MockServerClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withRequest(httpRequest).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public MockServerClient verifyZeroInteractions() throws AssertionError {
        Verification verification = Verification.verification().withRequest(HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public HttpRequest[] retrieveRecordedRequests(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        if (!Strings.isNullOrEmpty((String)httpResponse.getBodyAsString())) {
            return this.httpRequestSerializer.deserializeArray(httpResponse.getBodyAsString());
        }
        return new HttpRequest[0];
    }

    public Expectation[] retrieveExistingExpectations(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{"expectation"}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        if (!Strings.isNullOrEmpty((String)httpResponse.getBodyAsString())) {
            return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString());
        }
        return new Expectation[0];
    }

    public static enum TYPE {
        LOG,
        EXPECTATION,
        BOTH;

    }
}

