/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariablePartPrice;
import org.mobicents.protocols.ss7.cap.primitives.OctetStringBase;

public class VariablePartPriceImpl
extends OctetStringBase
implements VariablePartPrice {
    private static final String PRICE_INTEGER_PART = "priceIntegerPart";
    private static final String PRICE_HUNDREDTH_PART = "priceHundredthPart";
    protected static final XMLFormat<VariablePartPriceImpl> VARIABLE_PART_PRICE_XML = new XMLFormat<VariablePartPriceImpl>(VariablePartPriceImpl.class){

        public void read(XMLFormat.InputElement xml, VariablePartPriceImpl variablePartPrice) throws XMLStreamException {
            variablePartPrice.setPriceIntegerHundredthPart(xml.getAttribute(VariablePartPriceImpl.PRICE_INTEGER_PART, 0), xml.getAttribute(VariablePartPriceImpl.PRICE_HUNDREDTH_PART, 0));
        }

        public void write(VariablePartPriceImpl variablePartPrice, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(VariablePartPriceImpl.PRICE_INTEGER_PART, variablePartPrice.getPriceIntegerPart());
            xml.setAttribute(VariablePartPriceImpl.PRICE_HUNDREDTH_PART, variablePartPrice.getPriceHundredthPart());
        }
    };

    public VariablePartPriceImpl() {
        super(4, 4, "VariablePartPrice");
    }

    public VariablePartPriceImpl(byte[] data) {
        super(4, 4, "VariablePartPrice");
        this.data = data;
    }

    public VariablePartPriceImpl(double price) {
        super(4, 4, "VariablePartPrice");
        this.setPrice(price);
    }

    protected void setPrice(double price) {
        this.data = new byte[4];
        long val = (long)(price * 100.0);
        if (val < 0L) {
            val = -val;
        }
        this.data[0] = (byte)this.encodeByte((int)(val / 1000000L - val / 100000000L * 100L));
        this.data[1] = (byte)this.encodeByte((int)(val / 10000L - val / 1000000L * 100L));
        this.data[2] = (byte)this.encodeByte((int)(val / 100L - val / 10000L * 100L));
        this.data[3] = (byte)this.encodeByte((int)(val - val / 100L * 100L));
    }

    public VariablePartPriceImpl(int integerPart, int hundredthPart) {
        super(4, 4, "VariablePartPrice");
        this.setPriceIntegerHundredthPart(integerPart, hundredthPart);
    }

    protected void setPriceIntegerHundredthPart(int integerPart, int hundredthPart) {
        this.data = new byte[4];
        long val = (long)integerPart * 100L + (long)hundredthPart;
        if (val < 0L) {
            val = -val;
        }
        this.data[0] = (byte)this.encodeByte((int)(val / 1000000L - val / 100000000L * 100L));
        this.data[1] = (byte)this.encodeByte((int)(val / 10000L - val / 1000000L * 100L));
        this.data[2] = (byte)this.encodeByte((int)(val / 100L - val / 10000L * 100L));
        this.data[3] = (byte)this.encodeByte((int)(val - val / 100L * 100L));
    }

    public byte[] getData() {
        return this.data;
    }

    public double getPrice() {
        if (this.data == null || this.data.length != 4) {
            return Double.NaN;
        }
        double res = (double)(this.decodeByte(this.data[0]) * 10000 + this.decodeByte(this.data[1]) * 100 + this.decodeByte(this.data[2])) + (double)this.decodeByte(this.data[3]) / 100.0;
        return res;
    }

    public int getPriceIntegerPart() {
        if (this.data == null || this.data.length != 4) {
            return 0;
        }
        int res = this.decodeByte(this.data[0]) * 10000 + this.decodeByte(this.data[1]) * 100 + this.decodeByte(this.data[2]);
        return res;
    }

    public int getPriceHundredthPart() {
        if (this.data == null || this.data.length != 4) {
            return 0;
        }
        int res = this.decodeByte(this.data[3]);
        return res;
    }

    private int decodeByte(int bt) {
        return (bt & 0xF) * 10 + ((bt & 0xF0) >> 4);
    }

    private int encodeByte(int val) {
        return val / 10 | val % 10 << 4;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        double val = this.getPrice();
        if (!Double.isNaN(val)) {
            sb.append("price=");
            sb.append(val);
            sb.append(", integerPart=");
            sb.append(this.getPriceIntegerPart());
            sb.append(", hundredthPart=");
            sb.append(this.getPriceHundredthPart());
        }
        sb.append("]");
        return sb.toString();
    }
}

