/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.VariablePartDate;
import org.mobicents.protocols.ss7.cap.primitives.OctetStringBase;

public class VariablePartDateImpl
extends OctetStringBase
implements VariablePartDate {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    protected static final XMLFormat<VariablePartDateImpl> VARIABLE_PART_DATE_XML = new XMLFormat<VariablePartDateImpl>(VariablePartDateImpl.class){

        public void read(XMLFormat.InputElement xml, VariablePartDateImpl variablePartDate) throws XMLStreamException {
            VariablePartDateImpl.access$002(variablePartDate, new byte[4]);
            variablePartDate.setYear(xml.getAttribute(VariablePartDateImpl.YEAR, 0));
            variablePartDate.setMonth(xml.getAttribute(VariablePartDateImpl.MONTH, 0));
            variablePartDate.setDay(xml.getAttribute(VariablePartDateImpl.DAY, 0));
        }

        public void write(VariablePartDateImpl variablePartDate, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(VariablePartDateImpl.YEAR, variablePartDate.getYear());
            xml.setAttribute(VariablePartDateImpl.MONTH, variablePartDate.getMonth());
            xml.setAttribute(VariablePartDateImpl.DAY, variablePartDate.getDay());
        }
    };

    public VariablePartDateImpl() {
        super(4, 4, "VariablePartDate");
    }

    public VariablePartDateImpl(byte[] data) {
        super(4, 4, "VariablePartDate");
        this.data = data;
    }

    public VariablePartDateImpl(int year, int month, int day) {
        super(4, 4, "VariablePartDate");
        this.data = new byte[4];
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    protected void setYear(int year) {
        if (this.data == null || this.data.length != 4) {
            return;
        }
        this.data[0] = (byte)this.encodeByte(year / 100);
        this.data[1] = (byte)this.encodeByte(year % 100);
    }

    protected void setMonth(int month) {
        if (this.data == null || this.data.length != 4) {
            return;
        }
        this.data[2] = (byte)this.encodeByte(month);
    }

    protected void setDay(int day) {
        if (this.data == null || this.data.length != 4) {
            return;
        }
        this.data[3] = (byte)this.encodeByte(day);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getYear() {
        if (this.data == null || this.data.length != 4) {
            return 0;
        }
        return this.decodeByte(this.data[0]) * 100 + this.decodeByte(this.data[1]);
    }

    public int getMonth() {
        if (this.data == null || this.data.length != 4) {
            return 0;
        }
        return this.decodeByte(this.data[2]);
    }

    public int getDay() {
        if (this.data == null || this.data.length != 4) {
            return 0;
        }
        return this.decodeByte(this.data[3]);
    }

    private int decodeByte(int bt) {
        return (bt & 0xF) * 10 + ((bt & 0xF0) >> 4);
    }

    private int encodeByte(int val) {
        return val / 10 | val % 10 << 4;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.data != null && this.data.length == 4) {
            sb.append("year=");
            sb.append(this.getYear());
            sb.append(", month=");
            sb.append(this.getMonth());
            sb.append(", day=");
            sb.append(this.getDay());
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ byte[] access$002(VariablePartDateImpl x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

