/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.TimerID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ResetTimerRequest;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;

public class ResetTimerRequestImpl
extends CircuitSwitchedCallMessageImpl
implements ResetTimerRequest {
    private static final String TIMER_ID = "timerID";
    private static final String TIMER_VALUE = "timervalue";
    private static final String EXTENSIONS = "extensions";
    private static final String CALL_SEGMENT_ID = "callSegmentID";
    public static final int _ID_timerID = 0;
    public static final int _ID_timervalue = 1;
    public static final int _ID_extensions = 2;
    public static final int _ID_callSegmentID = 3;
    public static final String _PrimitiveName = "ResetTimerRequest";
    private TimerID timerID;
    private int timerValue;
    private CAPExtensions extensions;
    private Integer callSegmentID;
    protected static final XMLFormat<ResetTimerRequestImpl> RESET_TIMER_XML = new XMLFormat<ResetTimerRequestImpl>(ResetTimerRequestImpl.class){

        public void write(ResetTimerRequestImpl resetTimerRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write((Object)resetTimerRequest, xml);
            xml.setAttribute(ResetTimerRequestImpl.TIMER_ID, resetTimerRequest.timerID.name());
            xml.add((Object)resetTimerRequest.timerValue, ResetTimerRequestImpl.TIMER_VALUE, Integer.class);
            xml.add((Object)((CAPExtensionsImpl)resetTimerRequest.extensions), ResetTimerRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            xml.add((Object)resetTimerRequest.callSegmentID, ResetTimerRequestImpl.CALL_SEGMENT_ID, Integer.class);
        }

        public void read(XMLFormat.InputElement xml, ResetTimerRequestImpl resetTimerRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, (Object)resetTimerRequest);
            resetTimerRequest.timerID = TimerID.valueOf((String)xml.getAttribute(ResetTimerRequestImpl.TIMER_ID, TimerID.tssf.name()));
            resetTimerRequest.timerValue = (Integer)xml.get(ResetTimerRequestImpl.TIMER_VALUE, Integer.class);
            resetTimerRequest.extensions = (CAPExtensions)xml.get(ResetTimerRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            resetTimerRequest.callSegmentID = (Integer)xml.get(ResetTimerRequestImpl.CALL_SEGMENT_ID, Integer.class);
        }
    };

    public ResetTimerRequestImpl() {
    }

    public ResetTimerRequestImpl(TimerID timerID, int timerValue, CAPExtensions extensions, Integer callSegmentID) {
        this.timerID = timerID;
        this.timerValue = timerValue;
        this.extensions = extensions;
        this.callSegmentID = callSegmentID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.resetTimer_Request;
    }

    public int getOperationCode() {
        return 33;
    }

    public TimerID getTimerID() {
        return this.timerID;
    }

    public int getTimerValue() {
        return this.timerValue;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public Integer getCallSegmentID() {
        return this.callSegmentID;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ResetTimerRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ResetTimerRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ResetTimerRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ResetTimerRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.timerID = TimerID.tssf;
        this.timerValue = -1;
        this.extensions = null;
        this.callSegmentID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        int i1 = (int)ais.readInteger();
                        this.timerID = TimerID.getInstance((int)i1);
                        break;
                    }
                    case 1: {
                        this.timerValue = (int)ais.readInteger();
                        break;
                    }
                    case 2: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        this.callSegmentID = (int)ais.readInteger();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.timerValue == -1) {
            throw new CAPParsingComponentException("Error while decoding ResetTimerRequest: timerValue is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ResetTimerRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.timerID == null) {
            this.timerID = TimerID.tssf;
        }
        try {
            aos.writeInteger(2, 0, (long)this.timerID.getCode());
            aos.writeInteger(2, 1, (long)this.timerValue);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 2);
            }
            if (this.callSegmentID != null) {
                aos.writeInteger(2, 3, (long)this.callSegmentID.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ResetTimerRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ResetTimerRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.timerID != null) {
            sb.append(", timerID=");
            sb.append(this.timerID.toString());
        }
        sb.append(", timerValue=");
        sb.append(this.timerValue);
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.callSegmentID != null) {
            sb.append(", callSegmentID=");
            sb.append(this.callSegmentID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

