/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CalledPartyNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.CallingPartyNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.CauseCap;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.api.isup.LocationNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.OriginalCalledNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.RedirectingPartyIDCap;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.CalledPartyBCDNumber;
import org.mobicents.protocols.ss7.cap.api.primitives.EventTypeBCSM;
import org.mobicents.protocols.ss7.cap.api.primitives.TimeAndTimezone;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.InitialDPRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.BearerCapability;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CGEncountered;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.Carrier;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.IPSSPCapabilities;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.InitialDPArgExtension;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwo;
import org.mobicents.protocols.ss7.cap.isup.CalledPartyNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.CallingPartyNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.CauseCapImpl;
import org.mobicents.protocols.ss7.cap.isup.DigitsImpl;
import org.mobicents.protocols.ss7.cap.isup.LocationNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.OriginalCalledNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.RedirectingPartyIDCapImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.CalledPartyBCDNumberImpl;
import org.mobicents.protocols.ss7.cap.primitives.TimeAndTimezoneImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.BearerCapabilityImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CarrierImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.IPSSPCapabilitiesImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.InitialDPArgExtensionImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwoImpl;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.isup.CallingPartysCategoryInap;
import org.mobicents.protocols.ss7.inap.api.isup.HighLayerCompatibilityInap;
import org.mobicents.protocols.ss7.inap.api.isup.RedirectionInformationInap;
import org.mobicents.protocols.ss7.inap.isup.CallingPartysCategoryInapImpl;
import org.mobicents.protocols.ss7.inap.isup.HighLayerCompatibilityInapImpl;
import org.mobicents.protocols.ss7.inap.isup.RedirectionInformationInapImpl;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.callhandling.CallReferenceNumber;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.LocationInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.SubscriberState;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGIndex;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGInterlock;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtBasicServiceCode;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.CallReferenceNumberImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.LocationInformationImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.SubscriberStateImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGIndexImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGInterlockImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtBasicServiceCodeImpl;

public class InitialDPRequestImpl
extends CircuitSwitchedCallMessageImpl
implements InitialDPRequest {
    public static final int _ID_serviceKey = 0;
    public static final int _ID_calledPartyNumber = 2;
    public static final int _ID_callingPartyNumber = 3;
    public static final int _ID_callingPartysCategory = 5;
    public static final int _ID_cGEncountered = 7;
    public static final int _ID_iPSSPCapabilities = 8;
    public static final int _ID_locationNumber = 10;
    public static final int _ID_originalCalledPartyID = 12;
    public static final int _ID_extensions = 15;
    public static final int _ID_highLayerCompatibility = 23;
    public static final int _ID_additionalCallingPartyNumber = 25;
    public static final int _ID_bearerCapability = 27;
    public static final int _ID_eventTypeBCSM = 28;
    public static final int _ID_redirectingPartyID = 29;
    public static final int _ID_redirectionInformation = 30;
    public static final int _ID_cause = 17;
    public static final int _ID_serviceInteractionIndicatorsTwo = 32;
    public static final int _ID_carrier = 37;
    public static final int _ID_cug_Index = 45;
    public static final int _ID_cug_Interlock = 46;
    public static final int _ID_cug_OutgoingAccess = 47;
    public static final int _ID_iMSI = 50;
    public static final int _ID_subscriberState = 51;
    public static final int _ID_locationInformation = 52;
    public static final int _ID_ext_basicServiceCode = 53;
    public static final int _ID_callReferenceNumber = 54;
    public static final int _ID_mscAddress = 55;
    public static final int _ID_calledPartyBCDNumber = 56;
    public static final int _ID_timeAndTimezone = 57;
    public static final int _ID_callForwardingSS_Pending = 58;
    public static final int _ID_initialDPArgExtension = 59;
    private static final String IS_CAP_VERSION_3_OR_LATER = "isCAPVersion3orLater";
    private static final String SERVICE_KEY = "serviceKey";
    private static final String CALLED_PARTY_NUMBER = "calledPartyNumber";
    private static final String CALLING_PARTY_NUMBER = "callingPartyNumber";
    private static final String CALLING_PARTYS_CATEGORY = "callingPartysCategory";
    private static final String CG_ENCOUNTERED = "cgEncountered";
    private static final String IPSSP_CAPABILITIES = "ipsspCapabilities";
    private static final String LOCATION_NUMBER = "locationNumber";
    private static final String ORIGINAL_CALLED_PARTY_ID = "originalCalledPartyID";
    private static final String EXTENSIONS = "extensions";
    private static final String HIGH_LAYER_COMPATIBILITY = "highLayerCompatibility";
    private static final String ADDITIONAL_CALLING_PARTY_NUMBER = "additionalCallingPartyNumber";
    private static final String BEARER_CAPABILITY = "bearerCapability";
    private static final String EVENT_TYPE_BCSM = "eventTypeBCSM";
    private static final String REDIRECTING_PARTY_ID = "redirectingPartyID";
    private static final String REDIRECTION_INFORMATION = "redirectionInformation";
    private static final String CAUSE = "cause";
    private static final String SERVICE_INTERACTION_INDICATORS_TWO = "serviceInteractionIndicatorsTwo";
    private static final String CARRIER = "carrier";
    private static final String CUG_INDEX = "cugIndex";
    private static final String CUG_INTERLOCK = "cugInterlock";
    private static final String CUG_OUTGOING_ACCESS = "cugOutgoingAccess";
    private static final String IMSI = "imsi";
    private static final String SUBSCRIBER_STATE = "subscriberState";
    private static final String LOCATION_INFORMATION = "locationInformation";
    private static final String EXT_BASIC_SERVICE_CODE = "extBasicServiceCode";
    private static final String CALL_REFERENCE_NUMBER = "callReferenceNumber";
    private static final String MSC_ADDRESS = "mscAddress";
    private static final String CALLED_PARTY_BCD_NUMBER = "calledPartyBCDNumber";
    private static final String TIME_AND_TIMEZONE = "timeAndTimezone";
    private static final String CALL_FORWARDING_SS_PENDING = "callForwardingSSPending";
    private static final String INITIAL_DP_ARG_EXTENSION = "initialDPArgExtension";
    public static final String _PrimitiveName = "InitialDPRequestIndication";
    private int serviceKey;
    private CalledPartyNumberCap calledPartyNumber;
    private CallingPartyNumberCap callingPartyNumber;
    private CallingPartysCategoryInap callingPartysCategory;
    private CGEncountered CGEncountered;
    private IPSSPCapabilities IPSSPCapabilities;
    private LocationNumberCap locationNumber;
    private OriginalCalledNumberCap originalCalledPartyID;
    private CAPExtensions extensions;
    private HighLayerCompatibilityInap highLayerCompatibility;
    private Digits additionalCallingPartyNumber;
    private BearerCapability bearerCapability;
    private EventTypeBCSM eventTypeBCSM;
    private RedirectingPartyIDCap redirectingPartyID;
    private RedirectionInformationInap redirectionInformation;
    private CauseCap cause;
    private ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo;
    private Carrier carrier;
    private CUGIndex cugIndex;
    private CUGInterlock cugInterlock;
    private boolean cugOutgoingAccess;
    private IMSI imsi;
    private SubscriberState subscriberState;
    private LocationInformation locationInformation;
    private ExtBasicServiceCode extBasicServiceCode;
    private CallReferenceNumber callReferenceNumber;
    private ISDNAddressString mscAddress;
    private CalledPartyBCDNumber calledPartyBCDNumber;
    private TimeAndTimezone timeAndTimezone;
    private boolean callForwardingSSPending;
    private InitialDPArgExtension initialDPArgExtension;
    private boolean isCAPVersion3orLater;
    protected static final XMLFormat<InitialDPRequestImpl> INITIALDP_REQUEST_XML = new XMLFormat<InitialDPRequestImpl>(InitialDPRequestImpl.class){

        public void read(XMLFormat.InputElement xml, InitialDPRequestImpl initialDP) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, (Object)initialDP);
            initialDP.isCAPVersion3orLater = xml.getAttribute(InitialDPRequestImpl.IS_CAP_VERSION_3_OR_LATER, false);
            initialDP.serviceKey = (Integer)xml.get(InitialDPRequestImpl.SERVICE_KEY, Integer.class);
            initialDP.calledPartyNumber = (CalledPartyNumberCap)xml.get(InitialDPRequestImpl.CALLED_PARTY_NUMBER, CalledPartyNumberCapImpl.class);
            initialDP.callingPartyNumber = (CallingPartyNumberCap)xml.get(InitialDPRequestImpl.CALLING_PARTY_NUMBER, CallingPartyNumberCapImpl.class);
            initialDP.callingPartysCategory = (CallingPartysCategoryInap)xml.get(InitialDPRequestImpl.CALLING_PARTYS_CATEGORY, CallingPartysCategoryInapImpl.class);
            String str = (String)xml.get(InitialDPRequestImpl.CG_ENCOUNTERED, String.class);
            if (str != null) {
                initialDP.CGEncountered = Enum.valueOf(CGEncountered.class, str);
            }
            initialDP.IPSSPCapabilities = (IPSSPCapabilities)xml.get(InitialDPRequestImpl.IPSSP_CAPABILITIES, IPSSPCapabilitiesImpl.class);
            initialDP.locationNumber = (LocationNumberCap)xml.get(InitialDPRequestImpl.LOCATION_NUMBER, LocationNumberCapImpl.class);
            initialDP.originalCalledPartyID = (OriginalCalledNumberCap)xml.get(InitialDPRequestImpl.ORIGINAL_CALLED_PARTY_ID, OriginalCalledNumberCapImpl.class);
            initialDP.extensions = (CAPExtensions)xml.get(InitialDPRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            initialDP.highLayerCompatibility = (HighLayerCompatibilityInap)xml.get(InitialDPRequestImpl.HIGH_LAYER_COMPATIBILITY, HighLayerCompatibilityInapImpl.class);
            initialDP.additionalCallingPartyNumber = (Digits)xml.get(InitialDPRequestImpl.ADDITIONAL_CALLING_PARTY_NUMBER, DigitsImpl.class);
            initialDP.bearerCapability = (BearerCapability)xml.get(InitialDPRequestImpl.BEARER_CAPABILITY, BearerCapabilityImpl.class);
            str = (String)xml.get(InitialDPRequestImpl.EVENT_TYPE_BCSM, String.class);
            if (str != null) {
                initialDP.eventTypeBCSM = Enum.valueOf(EventTypeBCSM.class, str);
            }
            initialDP.redirectingPartyID = (RedirectingPartyIDCap)xml.get(InitialDPRequestImpl.REDIRECTING_PARTY_ID, RedirectingPartyIDCapImpl.class);
            initialDP.redirectionInformation = (RedirectionInformationInap)xml.get(InitialDPRequestImpl.REDIRECTION_INFORMATION, RedirectionInformationInapImpl.class);
            initialDP.cause = (CauseCap)xml.get(InitialDPRequestImpl.CAUSE, CauseCapImpl.class);
            initialDP.serviceInteractionIndicatorsTwo = (ServiceInteractionIndicatorsTwo)xml.get(InitialDPRequestImpl.SERVICE_INTERACTION_INDICATORS_TWO, ServiceInteractionIndicatorsTwoImpl.class);
            initialDP.carrier = (Carrier)xml.get(InitialDPRequestImpl.CARRIER, CarrierImpl.class);
            initialDP.cugIndex = (CUGIndex)xml.get(InitialDPRequestImpl.CUG_INDEX, CUGIndexImpl.class);
            initialDP.cugInterlock = (CUGInterlock)xml.get(InitialDPRequestImpl.CUG_INTERLOCK, CUGInterlockImpl.class);
            Boolean bval = (Boolean)xml.get(InitialDPRequestImpl.CUG_OUTGOING_ACCESS, Boolean.class);
            if (bval != null) {
                initialDP.cugOutgoingAccess = bval;
            }
            initialDP.imsi = (IMSI)xml.get(InitialDPRequestImpl.IMSI, IMSIImpl.class);
            initialDP.subscriberState = (SubscriberState)xml.get(InitialDPRequestImpl.SUBSCRIBER_STATE, SubscriberStateImpl.class);
            initialDP.locationInformation = (LocationInformation)xml.get(InitialDPRequestImpl.LOCATION_INFORMATION, LocationInformationImpl.class);
            initialDP.extBasicServiceCode = (ExtBasicServiceCode)xml.get(InitialDPRequestImpl.EXT_BASIC_SERVICE_CODE, ExtBasicServiceCodeImpl.class);
            initialDP.callReferenceNumber = (CallReferenceNumber)xml.get(InitialDPRequestImpl.CALL_REFERENCE_NUMBER, CallReferenceNumberImpl.class);
            initialDP.mscAddress = (ISDNAddressString)xml.get(InitialDPRequestImpl.MSC_ADDRESS, ISDNAddressStringImpl.class);
            initialDP.calledPartyBCDNumber = (CalledPartyBCDNumber)xml.get(InitialDPRequestImpl.CALLED_PARTY_BCD_NUMBER, CalledPartyBCDNumberImpl.class);
            initialDP.timeAndTimezone = (TimeAndTimezone)xml.get(InitialDPRequestImpl.TIME_AND_TIMEZONE, TimeAndTimezoneImpl.class);
            bval = (Boolean)xml.get(InitialDPRequestImpl.CALL_FORWARDING_SS_PENDING, Boolean.class);
            if (bval != null) {
                initialDP.callForwardingSSPending = bval;
            }
            initialDP.initialDPArgExtension = (InitialDPArgExtension)xml.get(InitialDPRequestImpl.INITIAL_DP_ARG_EXTENSION, InitialDPArgExtensionImpl.class);
        }

        public void write(InitialDPRequestImpl initialDP, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write((Object)initialDP, xml);
            xml.setAttribute(InitialDPRequestImpl.IS_CAP_VERSION_3_OR_LATER, initialDP.isCAPVersion3orLater);
            xml.add((Object)initialDP.getServiceKey(), InitialDPRequestImpl.SERVICE_KEY, Integer.class);
            if (initialDP.getCalledPartyNumber() != null) {
                xml.add((Object)((CalledPartyNumberCapImpl)initialDP.getCalledPartyNumber()), InitialDPRequestImpl.CALLED_PARTY_NUMBER, CalledPartyNumberCapImpl.class);
            }
            if (initialDP.getCallingPartyNumber() != null) {
                xml.add((Object)((CallingPartyNumberCapImpl)initialDP.getCallingPartyNumber()), InitialDPRequestImpl.CALLING_PARTY_NUMBER, CallingPartyNumberCapImpl.class);
            }
            if (initialDP.getCallingPartysCategory() != null) {
                xml.add((Object)((CallingPartysCategoryInapImpl)initialDP.getCallingPartysCategory()), InitialDPRequestImpl.CALLING_PARTYS_CATEGORY, CallingPartysCategoryInapImpl.class);
            }
            if (initialDP.getCGEncountered() != null) {
                xml.add((Object)initialDP.getCGEncountered().toString(), InitialDPRequestImpl.CG_ENCOUNTERED, String.class);
            }
            if (initialDP.getIPSSPCapabilities() != null) {
                xml.add((Object)((IPSSPCapabilitiesImpl)initialDP.getIPSSPCapabilities()), InitialDPRequestImpl.IPSSP_CAPABILITIES, IPSSPCapabilitiesImpl.class);
            }
            if (initialDP.getLocationNumber() != null) {
                xml.add((Object)((LocationNumberCapImpl)initialDP.getLocationNumber()), InitialDPRequestImpl.LOCATION_NUMBER, LocationNumberCapImpl.class);
            }
            if (initialDP.getOriginalCalledPartyID() != null) {
                xml.add((Object)((OriginalCalledNumberCapImpl)initialDP.getOriginalCalledPartyID()), InitialDPRequestImpl.ORIGINAL_CALLED_PARTY_ID, OriginalCalledNumberCapImpl.class);
            }
            if (initialDP.getExtensions() != null) {
                xml.add((Object)((CAPExtensionsImpl)initialDP.getExtensions()), InitialDPRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            }
            if (initialDP.getHighLayerCompatibility() != null) {
                xml.add((Object)((HighLayerCompatibilityInapImpl)initialDP.getHighLayerCompatibility()), InitialDPRequestImpl.HIGH_LAYER_COMPATIBILITY, HighLayerCompatibilityInapImpl.class);
            }
            if (initialDP.getAdditionalCallingPartyNumber() != null) {
                xml.add((Object)((DigitsImpl)initialDP.getAdditionalCallingPartyNumber()), InitialDPRequestImpl.ADDITIONAL_CALLING_PARTY_NUMBER, DigitsImpl.class);
            }
            if (initialDP.getBearerCapability() != null) {
                xml.add((Object)((BearerCapabilityImpl)initialDP.getBearerCapability()), InitialDPRequestImpl.BEARER_CAPABILITY, BearerCapabilityImpl.class);
            }
            if (initialDP.getEventTypeBCSM() != null) {
                xml.add((Object)initialDP.getEventTypeBCSM().toString(), InitialDPRequestImpl.EVENT_TYPE_BCSM, String.class);
            }
            if (initialDP.getRedirectingPartyID() != null) {
                xml.add((Object)((RedirectingPartyIDCapImpl)initialDP.getRedirectingPartyID()), InitialDPRequestImpl.REDIRECTING_PARTY_ID, RedirectingPartyIDCapImpl.class);
            }
            if (initialDP.getRedirectionInformation() != null) {
                xml.add((Object)((RedirectionInformationInapImpl)initialDP.getRedirectionInformation()), InitialDPRequestImpl.REDIRECTION_INFORMATION, RedirectionInformationInapImpl.class);
            }
            if (initialDP.getCause() != null) {
                xml.add((Object)((CauseCapImpl)initialDP.getCause()), InitialDPRequestImpl.CAUSE, CauseCapImpl.class);
            }
            if (initialDP.serviceInteractionIndicatorsTwo != null) {
                xml.add((Object)((ServiceInteractionIndicatorsTwoImpl)initialDP.serviceInteractionIndicatorsTwo), InitialDPRequestImpl.SERVICE_INTERACTION_INDICATORS_TWO, ServiceInteractionIndicatorsTwoImpl.class);
            }
            if (initialDP.carrier != null) {
                xml.add((Object)((CarrierImpl)initialDP.carrier), InitialDPRequestImpl.CARRIER, CarrierImpl.class);
            }
            if (initialDP.cugIndex != null) {
                xml.add((Object)((CUGIndexImpl)initialDP.cugIndex), InitialDPRequestImpl.CUG_INDEX, CUGIndexImpl.class);
            }
            if (initialDP.cugInterlock != null) {
                xml.add((Object)((CUGInterlockImpl)initialDP.cugInterlock), InitialDPRequestImpl.CUG_INTERLOCK, CUGInterlockImpl.class);
            }
            if (initialDP.cugOutgoingAccess) {
                xml.add((Object)initialDP.cugOutgoingAccess, InitialDPRequestImpl.CUG_OUTGOING_ACCESS, Boolean.class);
            }
            if (initialDP.getIMSI() != null) {
                xml.add((Object)((IMSIImpl)initialDP.getIMSI()), InitialDPRequestImpl.IMSI, IMSIImpl.class);
            }
            if (initialDP.getSubscriberState() != null) {
                xml.add((Object)((SubscriberStateImpl)initialDP.getSubscriberState()), InitialDPRequestImpl.SUBSCRIBER_STATE, SubscriberStateImpl.class);
            }
            if (initialDP.getLocationInformation() != null) {
                xml.add((Object)((LocationInformationImpl)initialDP.getLocationInformation()), InitialDPRequestImpl.LOCATION_INFORMATION, LocationInformationImpl.class);
            }
            if (initialDP.getExtBasicServiceCode() != null) {
                xml.add((Object)((ExtBasicServiceCodeImpl)initialDP.getExtBasicServiceCode()), InitialDPRequestImpl.EXT_BASIC_SERVICE_CODE, ExtBasicServiceCodeImpl.class);
            }
            if (initialDP.getCallReferenceNumber() != null) {
                xml.add((Object)((CallReferenceNumberImpl)initialDP.getCallReferenceNumber()), InitialDPRequestImpl.CALL_REFERENCE_NUMBER, CallReferenceNumberImpl.class);
            }
            if (initialDP.getMscAddress() != null) {
                xml.add((Object)((ISDNAddressStringImpl)initialDP.getMscAddress()), InitialDPRequestImpl.MSC_ADDRESS, ISDNAddressStringImpl.class);
            }
            if (initialDP.getCalledPartyBCDNumber() != null) {
                xml.add((Object)((CalledPartyBCDNumberImpl)initialDP.getCalledPartyBCDNumber()), InitialDPRequestImpl.CALLED_PARTY_BCD_NUMBER, CalledPartyBCDNumberImpl.class);
            }
            if (initialDP.getTimeAndTimezone() != null) {
                xml.add((Object)((TimeAndTimezoneImpl)initialDP.getTimeAndTimezone()), InitialDPRequestImpl.TIME_AND_TIMEZONE, TimeAndTimezoneImpl.class);
            }
            if (initialDP.getCallForwardingSSPending()) {
                xml.add((Object)initialDP.getCallForwardingSSPending(), InitialDPRequestImpl.CALL_FORWARDING_SS_PENDING, Boolean.class);
            }
            if (initialDP.getInitialDPArgExtension() != null) {
                xml.add((Object)((InitialDPArgExtensionImpl)initialDP.getInitialDPArgExtension()), InitialDPRequestImpl.INITIAL_DP_ARG_EXTENSION, InitialDPArgExtensionImpl.class);
            }
        }
    };

    public InitialDPRequestImpl() {
    }

    public InitialDPRequestImpl(boolean isCAPVersion3orLater) {
        this.isCAPVersion3orLater = isCAPVersion3orLater;
    }

    public InitialDPRequestImpl(int serviceKey, CalledPartyNumberCap calledPartyNumber, CallingPartyNumberCap callingPartyNumber, CallingPartysCategoryInap callingPartysCategory, CGEncountered CGEncountered2, IPSSPCapabilities IPSSPCapabilities2, LocationNumberCap locationNumber, OriginalCalledNumberCap originalCalledPartyID, CAPExtensions extensions, HighLayerCompatibilityInap highLayerCompatibility, Digits additionalCallingPartyNumber, BearerCapability bearerCapability, EventTypeBCSM eventTypeBCSM, RedirectingPartyIDCap redirectingPartyID, RedirectionInformationInap redirectionInformation, CauseCap cause, ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo, Carrier carrier, CUGIndex cugIndex, CUGInterlock cugInterlock, boolean cugOutgoingAccess, IMSI imsi, SubscriberState subscriberState, LocationInformation locationInformation, ExtBasicServiceCode extBasicServiceCode, CallReferenceNumber callReferenceNumber, ISDNAddressString mscAddress, CalledPartyBCDNumber calledPartyBCDNumber, TimeAndTimezone timeAndTimezone, boolean callForwardingSSPending, InitialDPArgExtension initialDPArgExtension, boolean isCAPVersion3orLater) {
        this.serviceKey = serviceKey;
        this.calledPartyNumber = calledPartyNumber;
        this.callingPartyNumber = callingPartyNumber;
        this.callingPartysCategory = callingPartysCategory;
        this.CGEncountered = CGEncountered2;
        this.IPSSPCapabilities = IPSSPCapabilities2;
        this.locationNumber = locationNumber;
        this.originalCalledPartyID = originalCalledPartyID;
        this.extensions = extensions;
        this.highLayerCompatibility = highLayerCompatibility;
        this.additionalCallingPartyNumber = additionalCallingPartyNumber;
        this.bearerCapability = bearerCapability;
        this.eventTypeBCSM = eventTypeBCSM;
        this.redirectingPartyID = redirectingPartyID;
        this.redirectionInformation = redirectionInformation;
        this.cause = cause;
        this.serviceInteractionIndicatorsTwo = serviceInteractionIndicatorsTwo;
        this.carrier = carrier;
        this.cugIndex = cugIndex;
        this.cugInterlock = cugInterlock;
        this.cugOutgoingAccess = cugOutgoingAccess;
        this.imsi = imsi;
        this.subscriberState = subscriberState;
        this.locationInformation = locationInformation;
        this.extBasicServiceCode = extBasicServiceCode;
        this.callReferenceNumber = callReferenceNumber;
        this.mscAddress = mscAddress;
        this.calledPartyBCDNumber = calledPartyBCDNumber;
        this.timeAndTimezone = timeAndTimezone;
        this.callForwardingSSPending = callForwardingSSPending;
        this.initialDPArgExtension = initialDPArgExtension;
        this.isCAPVersion3orLater = isCAPVersion3orLater;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.initialDP_Request;
    }

    public int getOperationCode() {
        return 0;
    }

    public int getServiceKey() {
        return this.serviceKey;
    }

    public CalledPartyNumberCap getCalledPartyNumber() {
        return this.calledPartyNumber;
    }

    public CallingPartyNumberCap getCallingPartyNumber() {
        return this.callingPartyNumber;
    }

    public CallingPartysCategoryInap getCallingPartysCategory() {
        return this.callingPartysCategory;
    }

    public CGEncountered getCGEncountered() {
        return this.CGEncountered;
    }

    public IPSSPCapabilities getIPSSPCapabilities() {
        return this.IPSSPCapabilities;
    }

    public LocationNumberCap getLocationNumber() {
        return this.locationNumber;
    }

    public OriginalCalledNumberCap getOriginalCalledPartyID() {
        return this.originalCalledPartyID;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public HighLayerCompatibilityInap getHighLayerCompatibility() {
        return this.highLayerCompatibility;
    }

    public Digits getAdditionalCallingPartyNumber() {
        return this.additionalCallingPartyNumber;
    }

    public BearerCapability getBearerCapability() {
        return this.bearerCapability;
    }

    public EventTypeBCSM getEventTypeBCSM() {
        return this.eventTypeBCSM;
    }

    public RedirectingPartyIDCap getRedirectingPartyID() {
        return this.redirectingPartyID;
    }

    public RedirectionInformationInap getRedirectionInformation() {
        return this.redirectionInformation;
    }

    public CauseCap getCause() {
        return this.cause;
    }

    public ServiceInteractionIndicatorsTwo getServiceInteractionIndicatorsTwo() {
        return this.serviceInteractionIndicatorsTwo;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public CUGIndex getCugIndex() {
        return this.cugIndex;
    }

    public CUGInterlock getCugInterlock() {
        return this.cugInterlock;
    }

    public boolean getCugOutgoingAccess() {
        return this.cugOutgoingAccess;
    }

    public IMSI getIMSI() {
        return this.imsi;
    }

    public SubscriberState getSubscriberState() {
        return this.subscriberState;
    }

    public LocationInformation getLocationInformation() {
        return this.locationInformation;
    }

    public ExtBasicServiceCode getExtBasicServiceCode() {
        return this.extBasicServiceCode;
    }

    public CallReferenceNumber getCallReferenceNumber() {
        return this.callReferenceNumber;
    }

    public ISDNAddressString getMscAddress() {
        return this.mscAddress;
    }

    public CalledPartyBCDNumber getCalledPartyBCDNumber() {
        return this.calledPartyBCDNumber;
    }

    public TimeAndTimezone getTimeAndTimezone() {
        return this.timeAndTimezone;
    }

    public boolean getCallForwardingSSPending() {
        return this.callForwardingSSPending;
    }

    public InitialDPArgExtension getInitialDPArgExtension() {
        return this.initialDPArgExtension;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws INAPParsingComponentException, CAPParsingComponentException, MAPParsingComponentException, IOException, AsnException {
        this.serviceKey = 0;
        this.calledPartyNumber = null;
        this.callingPartyNumber = null;
        this.callingPartysCategory = null;
        this.CGEncountered = null;
        this.IPSSPCapabilities = null;
        this.locationNumber = null;
        this.originalCalledPartyID = null;
        this.extensions = null;
        this.highLayerCompatibility = null;
        this.additionalCallingPartyNumber = null;
        this.bearerCapability = null;
        this.eventTypeBCSM = null;
        this.redirectingPartyID = null;
        this.redirectionInformation = null;
        this.cause = null;
        this.serviceInteractionIndicatorsTwo = null;
        this.carrier = null;
        this.cugIndex = null;
        this.cugInterlock = null;
        this.cugOutgoingAccess = false;
        this.imsi = null;
        this.subscriberState = null;
        this.locationInformation = null;
        this.extBasicServiceCode = null;
        this.callReferenceNumber = null;
        this.mscAddress = null;
        this.calledPartyBCDNumber = null;
        this.timeAndTimezone = null;
        this.callForwardingSSPending = false;
        this.initialDPArgExtension = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 2 || tag != 0 || !ais.isTagPrimitive()) {
                        throw new CAPParsingComponentException("Error while decoding InitialDPRequest: Parameter 0 bad tag or tag class or not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.serviceKey = (int)ais.readInteger();
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 2: {
                                this.calledPartyNumber = new CalledPartyNumberCapImpl();
                                ((CalledPartyNumberCapImpl)this.calledPartyNumber).decodeAll(ais);
                                break block0;
                            }
                            case 3: {
                                this.callingPartyNumber = new CallingPartyNumberCapImpl();
                                ((CallingPartyNumberCapImpl)this.callingPartyNumber).decodeAll(ais);
                                break block0;
                            }
                            case 5: {
                                this.callingPartysCategory = new CallingPartysCategoryInapImpl();
                                ((CallingPartysCategoryInapImpl)this.callingPartysCategory).decodeAll(ais);
                                break block0;
                            }
                            case 7: {
                                int i1 = (int)ais.readInteger();
                                this.CGEncountered = org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CGEncountered.getInstance((int)i1);
                                break block0;
                            }
                            case 8: {
                                this.IPSSPCapabilities = new IPSSPCapabilitiesImpl();
                                ((IPSSPCapabilitiesImpl)this.IPSSPCapabilities).decodeAll(ais);
                                break block0;
                            }
                            case 10: {
                                this.locationNumber = new LocationNumberCapImpl();
                                ((LocationNumberCapImpl)this.locationNumber).decodeAll(ais);
                                break block0;
                            }
                            case 12: {
                                this.originalCalledPartyID = new OriginalCalledNumberCapImpl();
                                ((OriginalCalledNumberCapImpl)this.originalCalledPartyID).decodeAll(ais);
                                break block0;
                            }
                            case 15: {
                                this.extensions = new CAPExtensionsImpl();
                                ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                                break block0;
                            }
                            case 23: {
                                this.highLayerCompatibility = new HighLayerCompatibilityInapImpl();
                                ((HighLayerCompatibilityInapImpl)this.highLayerCompatibility).decodeAll(ais);
                                break block0;
                            }
                            case 25: {
                                this.additionalCallingPartyNumber = new DigitsImpl();
                                ((DigitsImpl)this.additionalCallingPartyNumber).decodeAll(ais);
                                this.additionalCallingPartyNumber.setIsGenericNumber();
                                break block0;
                            }
                            case 27: {
                                AsnInputStream ais2 = ais.readSequenceStream();
                                ais2.readTag();
                                this.bearerCapability = new BearerCapabilityImpl();
                                ((BearerCapabilityImpl)this.bearerCapability).decodeAll(ais2);
                                break block0;
                            }
                            case 28: {
                                int i1 = (int)ais.readInteger();
                                this.eventTypeBCSM = EventTypeBCSM.getInstance((int)i1);
                                break block0;
                            }
                            case 29: {
                                this.redirectingPartyID = new RedirectingPartyIDCapImpl();
                                ((RedirectingPartyIDCapImpl)this.redirectingPartyID).decodeAll(ais);
                                break block0;
                            }
                            case 30: {
                                this.redirectionInformation = new RedirectionInformationInapImpl();
                                ((RedirectionInformationInapImpl)this.redirectionInformation).decodeAll(ais);
                                break block0;
                            }
                            case 17: {
                                this.cause = new CauseCapImpl();
                                ((CauseCapImpl)this.cause).decodeAll(ais);
                                break block0;
                            }
                            case 32: {
                                this.serviceInteractionIndicatorsTwo = new ServiceInteractionIndicatorsTwoImpl();
                                ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).decodeAll(ais);
                                break block0;
                            }
                            case 37: {
                                this.carrier = new CarrierImpl();
                                ((CarrierImpl)this.carrier).decodeAll(ais);
                                break block0;
                            }
                            case 45: {
                                this.cugIndex = new CUGIndexImpl();
                                ((CUGIndexImpl)this.cugIndex).decodeAll(ais);
                                break block0;
                            }
                            case 46: {
                                this.cugInterlock = new CUGInterlockImpl();
                                ((CUGInterlockImpl)this.cugInterlock).decodeAll(ais);
                                break block0;
                            }
                            case 47: {
                                ais.readNull();
                                this.cugOutgoingAccess = true;
                                break block0;
                            }
                            case 50: {
                                int len = ais.readLength();
                                if (len == 0) {
                                    ais.advanceElementData(len);
                                    break block0;
                                }
                                this.imsi = new IMSIImpl();
                                ((IMSIImpl)this.imsi).decodeData(ais, len);
                                break block0;
                            }
                            case 51: {
                                AsnInputStream ais2 = ais.readSequenceStream();
                                ais2.readTag();
                                this.subscriberState = new SubscriberStateImpl();
                                ((SubscriberStateImpl)this.subscriberState).decodeAll(ais2);
                                break block0;
                            }
                            case 52: {
                                this.locationInformation = new LocationInformationImpl();
                                ((LocationInformationImpl)this.locationInformation).decodeAll(ais);
                                break block0;
                            }
                            case 53: {
                                AsnInputStream ais2 = ais.readSequenceStream();
                                ais2.readTag();
                                this.extBasicServiceCode = new ExtBasicServiceCodeImpl();
                                ((ExtBasicServiceCodeImpl)this.extBasicServiceCode).decodeAll(ais2);
                                break block0;
                            }
                            case 54: {
                                this.callReferenceNumber = new CallReferenceNumberImpl();
                                ((CallReferenceNumberImpl)this.callReferenceNumber).decodeAll(ais);
                                break block0;
                            }
                            case 55: {
                                this.mscAddress = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.mscAddress).decodeAll(ais);
                                break block0;
                            }
                            case 56: {
                                this.calledPartyBCDNumber = new CalledPartyBCDNumberImpl();
                                ((CalledPartyBCDNumberImpl)this.calledPartyBCDNumber).decodeAll(ais);
                                break block0;
                            }
                            case 57: {
                                this.timeAndTimezone = new TimeAndTimezoneImpl();
                                ((TimeAndTimezoneImpl)this.timeAndTimezone).decodeAll(ais);
                                break block0;
                            }
                            case 58: {
                                ais.readNull();
                                this.callForwardingSSPending = true;
                                break block0;
                            }
                            case 59: {
                                this.initialDPArgExtension = new InitialDPArgExtensionImpl(this.isCAPVersion3orLater);
                                ((InitialDPArgExtensionImpl)this.initialDPArgExtension).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 1) {
            throw new CAPParsingComponentException("Error while decoding InitialDPRequestIndication: Needs at least 1 mandatory parameters, found " + num, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            int pos;
            aos.writeInteger(2, 0, (long)this.serviceKey);
            if (this.calledPartyNumber != null) {
                ((CalledPartyNumberCapImpl)this.calledPartyNumber).encodeAll(aos, 2, 2);
            }
            if (this.callingPartyNumber != null) {
                ((CallingPartyNumberCapImpl)this.callingPartyNumber).encodeAll(aos, 2, 3);
            }
            if (this.callingPartysCategory != null) {
                ((CallingPartysCategoryInapImpl)this.callingPartysCategory).encodeAll(aos, 2, 5);
            }
            if (this.CGEncountered != null) {
                aos.writeInteger(2, 7, (long)this.CGEncountered.getCode());
            }
            if (this.IPSSPCapabilities != null) {
                ((IPSSPCapabilitiesImpl)this.IPSSPCapabilities).encodeAll(aos, 2, 8);
            }
            if (this.locationNumber != null) {
                ((LocationNumberCapImpl)this.locationNumber).encodeAll(aos, 2, 10);
            }
            if (this.originalCalledPartyID != null) {
                ((OriginalCalledNumberCapImpl)this.originalCalledPartyID).encodeAll(aos, 2, 12);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 15);
            }
            if (this.highLayerCompatibility != null) {
                ((HighLayerCompatibilityInapImpl)this.highLayerCompatibility).encodeAll(aos, 2, 23);
            }
            if (this.additionalCallingPartyNumber != null) {
                ((DigitsImpl)this.additionalCallingPartyNumber).encodeAll(aos, 2, 25);
            }
            if (this.bearerCapability != null) {
                aos.writeTag(2, false, 27);
                pos = aos.StartContentDefiniteLength();
                ((BearerCapabilityImpl)this.bearerCapability).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.eventTypeBCSM != null) {
                aos.writeInteger(2, 28, (long)this.eventTypeBCSM.getCode());
            }
            if (this.redirectingPartyID != null) {
                ((RedirectingPartyIDCapImpl)this.redirectingPartyID).encodeAll(aos, 2, 29);
            }
            if (this.redirectionInformation != null) {
                ((RedirectionInformationInapImpl)this.redirectionInformation).encodeAll(aos, 2, 30);
            }
            if (this.cause != null) {
                ((CauseCapImpl)this.cause).encodeAll(aos, 2, 17);
            }
            if (this.serviceInteractionIndicatorsTwo != null) {
                ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).encodeAll(aos, 2, 32);
            }
            if (this.carrier != null) {
                ((CarrierImpl)this.carrier).encodeAll(aos, 2, 37);
            }
            if (this.cugIndex != null) {
                ((CUGIndexImpl)this.cugIndex).encodeAll(aos, 2, 45);
            }
            if (this.cugInterlock != null) {
                ((CUGInterlockImpl)this.cugInterlock).encodeAll(aos, 2, 46);
                this.cugInterlock = new CUGInterlockImpl();
            }
            if (this.cugOutgoingAccess) {
                aos.writeNull(2, 47);
            }
            if (this.imsi != null) {
                ((IMSIImpl)this.imsi).encodeAll(aos, 2, 50);
            }
            if (this.subscriberState != null) {
                aos.writeTag(2, false, 51);
                pos = aos.StartContentDefiniteLength();
                ((SubscriberStateImpl)this.subscriberState).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.locationInformation != null) {
                ((LocationInformationImpl)this.locationInformation).encodeAll(aos, 2, 52);
            }
            if (this.extBasicServiceCode != null) {
                aos.writeTag(2, false, 53);
                pos = aos.StartContentDefiniteLength();
                ((ExtBasicServiceCodeImpl)this.extBasicServiceCode).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.callReferenceNumber != null) {
                ((CallReferenceNumberImpl)this.callReferenceNumber).encodeAll(aos, 2, 54);
            }
            if (this.mscAddress != null) {
                ((ISDNAddressStringImpl)this.mscAddress).encodeAll(aos, 2, 55);
            }
            if (this.calledPartyBCDNumber != null) {
                ((CalledPartyBCDNumberImpl)this.calledPartyBCDNumber).encodeAll(aos, 2, 56);
            }
            if (this.timeAndTimezone != null) {
                ((TimeAndTimezoneImpl)this.timeAndTimezone).encodeAll(aos, 2, 57);
            }
            if (this.callForwardingSSPending) {
                aos.writeNull(2, 58);
            }
            if (this.initialDPArgExtension != null) {
                ((InitialDPArgExtensionImpl)this.initialDPArgExtension).encodeAll(aos, 2, 59);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (INAPException e) {
            throw new CAPException("INAPException when encoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (MAPException e) {
            throw new CAPException("MAPException when encoding InitialDPRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        sb.append(", serviceKey=");
        sb.append(this.serviceKey);
        if (this.calledPartyNumber != null) {
            sb.append(", calledPartyNumber=");
            sb.append(this.calledPartyNumber.toString());
        }
        if (this.callingPartyNumber != null) {
            sb.append(", callingPartyNumber=");
            sb.append(this.callingPartyNumber.toString());
        }
        if (this.callingPartysCategory != null) {
            sb.append(", callingPartysCategory=");
            sb.append(this.callingPartysCategory.toString());
        }
        if (this.CGEncountered != null) {
            sb.append(", CGEncountered=");
            sb.append(this.CGEncountered.toString());
        }
        if (this.IPSSPCapabilities != null) {
            sb.append(", IPSSPCapabilities=");
            sb.append(this.IPSSPCapabilities.toString());
        }
        if (this.locationNumber != null) {
            sb.append(", locationNumber=");
            sb.append(this.locationNumber.toString());
        }
        if (this.originalCalledPartyID != null) {
            sb.append(", originalCalledPartyID=");
            sb.append(this.originalCalledPartyID.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.highLayerCompatibility != null) {
            sb.append(", highLayerCompatibility=");
            sb.append(this.highLayerCompatibility.toString());
        }
        if (this.additionalCallingPartyNumber != null) {
            sb.append(", additionalCallingPartyNumber=");
            sb.append(this.additionalCallingPartyNumber.toString());
        }
        if (this.bearerCapability != null) {
            sb.append(", bearerCapability=");
            sb.append(this.bearerCapability.toString());
        }
        if (this.eventTypeBCSM != null) {
            sb.append(", eventTypeBCSM=");
            sb.append(this.eventTypeBCSM.toString());
        }
        if (this.redirectingPartyID != null) {
            sb.append(", redirectingPartyID=");
            sb.append(this.redirectingPartyID.toString());
        }
        if (this.redirectionInformation != null) {
            sb.append(", redirectionInformation=");
            sb.append(this.redirectionInformation.toString());
        }
        if (this.cause != null) {
            sb.append(", cause=");
            sb.append(this.cause.toString());
        }
        if (this.serviceInteractionIndicatorsTwo != null) {
            sb.append(", serviceInteractionIndicatorsTwo=");
            sb.append(this.serviceInteractionIndicatorsTwo.toString());
        }
        if (this.carrier != null) {
            sb.append(", carrier=");
            sb.append(this.carrier.toString());
        }
        if (this.cugIndex != null) {
            sb.append(", cugIndex=");
            sb.append(this.cugIndex.toString());
        }
        if (this.cugInterlock != null) {
            sb.append(", cugInterlock=");
            sb.append(this.cugInterlock.toString());
        }
        if (this.cugOutgoingAccess) {
            sb.append(", cugOutgoingAccess");
        }
        if (this.imsi != null) {
            sb.append(", imsi=");
            sb.append(this.imsi.toString());
        }
        if (this.subscriberState != null) {
            sb.append(", subscriberState=");
            sb.append(this.subscriberState.toString());
        }
        if (this.locationInformation != null) {
            sb.append(", locationInformation=");
            sb.append(this.locationInformation.toString());
        }
        if (this.extBasicServiceCode != null) {
            sb.append(", extBasicServiceCode=");
            sb.append(this.extBasicServiceCode.toString());
        }
        if (this.callReferenceNumber != null) {
            sb.append(", callReferenceNumber=");
            sb.append(this.callReferenceNumber.toString());
        }
        if (this.mscAddress != null) {
            sb.append(", mscAddress=");
            sb.append(this.mscAddress.toString());
        }
        if (this.calledPartyBCDNumber != null) {
            sb.append(", calledPartyBCDNumber=");
            sb.append(this.calledPartyBCDNumber.toString());
        }
        if (this.timeAndTimezone != null) {
            sb.append(", timeAndTimezone=");
            sb.append(this.timeAndTimezone.toString());
        }
        if (this.callForwardingSSPending) {
            sb.append(", callForwardingSSPending");
        }
        if (this.initialDPArgExtension != null) {
            sb.append(", initialDPArgExtension=");
            sb.append(this.initialDPArgExtension.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

