/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.ReceivingSideID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CallInformationReportRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.RequestedInformation;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.ReceivingSideIDImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.RequestedInformationImpl;

public class CallInformationReportRequestImpl
extends CircuitSwitchedCallMessageImpl
implements CallInformationReportRequest {
    public static final int _ID_requestedInformationList = 0;
    public static final int _ID_extensions = 2;
    public static final int _ID_legID = 3;
    public static final String _PrimitiveName = "CallInformationReportRequestIndication";
    private ArrayList<RequestedInformation> requestedInformationList;
    private CAPExtensions extensions;
    private ReceivingSideID legID;

    public CallInformationReportRequestImpl() {
    }

    public CallInformationReportRequestImpl(ArrayList<RequestedInformation> requestedInformationList, CAPExtensions extensions, ReceivingSideID legID) {
        this.requestedInformationList = requestedInformationList;
        this.extensions = extensions;
        this.legID = legID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.callInformationReport_Request;
    }

    public int getOperationCode() {
        return 44;
    }

    public ArrayList<RequestedInformation> getRequestedInformationList() {
        return this.requestedInformationList;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public ReceivingSideID getLegID() {
        return this.legID;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CallInformationReportRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CallInformationReportRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CallInformationReportRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CallInformationReportRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.requestedInformationList = null;
        this.extensions = null;
        this.legID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.requestedInformationList = new ArrayList();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                throw new CAPParsingComponentException("Error while decoding CallInformationReportRequestIndication: bad RequestedInformation tag or tagClass or RequestedInformation is primitive ", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            RequestedInformationImpl el = new RequestedInformationImpl();
                            el.decodeAll(ais2);
                            this.requestedInformationList.add(el);
                        }
                        break;
                    }
                    case 2: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.legID = new ReceivingSideIDImpl();
                        ((ReceivingSideIDImpl)this.legID).decodeAll(ais2);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.requestedInformationList == null) {
            throw new CAPParsingComponentException("Error while decoding CallInformationReportRequestIndication: requestedInformationList is mandatory but not found ", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CallInformationReportRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.requestedInformationList == null) {
            throw new CAPException("Error while encoding CallInformationReportRequestIndication: requestedInformationList must not be null");
        }
        if (this.requestedInformationList.size() < 1 || this.requestedInformationList.size() > 4) {
            throw new CAPException("Error while encoding CallInformationReportRequestIndication: requestedInformationList size must be from 1 to 4");
        }
        try {
            aos.writeTag(2, false, 0);
            int pos = aos.StartContentDefiniteLength();
            for (RequestedInformation ri : this.requestedInformationList) {
                RequestedInformationImpl rii = (RequestedInformationImpl)ri;
                rii.encodeAll(aos, rii.getTagClass(), rii.getTag());
            }
            aos.FinalizeContent(pos);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 2);
            }
            if (this.legID != null) {
                aos.writeTag(2, false, 3);
                pos = aos.StartContentDefiniteLength();
                ((ReceivingSideIDImpl)this.legID).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CallInformationReportRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.requestedInformationList != null) {
            sb.append(", requestedInformationList=[");
            boolean firstItem = true;
            for (RequestedInformation ri : this.requestedInformationList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append("requestedInformation=[");
                sb.append(ri.toString());
                sb.append("]");
            }
            sb.append("]");
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.legID != null) {
            sb.append(", legID=");
            sb.append(this.legID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

