/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.BCSMEvent;
import org.mobicents.protocols.ss7.cap.api.primitives.EventTypeBCSM;
import org.mobicents.protocols.ss7.cap.api.primitives.MonitorMode;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.DpSpecificCriteria;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.DpSpecificCriteriaImpl;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.primitives.LegID;
import org.mobicents.protocols.ss7.inap.primitives.LegIDImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class BCSMEventImpl
extends SequenceBase
implements BCSMEvent {
    public static final int _ID_eventTypeBCSM = 0;
    public static final int _ID_monitorMode = 1;
    public static final int _ID_legID = 2;
    public static final int _ID_dpSpecificCriteria = 30;
    public static final int _ID_automaticRearm = 50;
    private static final String EVENT_TYPE_BCSM = "eventTypeBCSM";
    private static final String MONITOR_MODE = "monitorMode";
    private static final String LEG_ID = "legID";
    private static final String DP_SPECIFIC_CRITERIA = "dpSpecificCriteria";
    private static final String AUTOMATIC_REARM = "automaticRearm";
    private EventTypeBCSM eventTypeBCSM;
    private MonitorMode monitorMode;
    private LegID legID;
    private DpSpecificCriteria dpSpecificCriteria;
    private boolean automaticRearm;
    protected static final XMLFormat<BCSMEventImpl> BCSM_EVENT_XML = new XMLFormat<BCSMEventImpl>(BCSMEventImpl.class){

        public void read(XMLFormat.InputElement xml, BCSMEventImpl bcsmEvent) throws XMLStreamException {
            String str = (String)xml.get(BCSMEventImpl.EVENT_TYPE_BCSM, String.class);
            if (str != null) {
                bcsmEvent.eventTypeBCSM = Enum.valueOf(EventTypeBCSM.class, str);
            }
            if ((str = (String)xml.get(BCSMEventImpl.MONITOR_MODE, String.class)) != null) {
                bcsmEvent.monitorMode = Enum.valueOf(MonitorMode.class, str);
            }
            bcsmEvent.legID = (LegID)xml.get(BCSMEventImpl.LEG_ID, LegIDImpl.class);
            bcsmEvent.dpSpecificCriteria = (DpSpecificCriteria)xml.get(BCSMEventImpl.DP_SPECIFIC_CRITERIA, DpSpecificCriteriaImpl.class);
            Boolean bval = (Boolean)xml.get(BCSMEventImpl.AUTOMATIC_REARM, Boolean.class);
            if (bval != null) {
                bcsmEvent.automaticRearm = bval;
            }
        }

        public void write(BCSMEventImpl bcsmEvent, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (bcsmEvent.getEventTypeBCSM() != null) {
                xml.add((Object)bcsmEvent.getEventTypeBCSM().toString(), BCSMEventImpl.EVENT_TYPE_BCSM, String.class);
            }
            if (bcsmEvent.getMonitorMode() != null) {
                xml.add((Object)bcsmEvent.getMonitorMode().toString(), BCSMEventImpl.MONITOR_MODE, String.class);
            }
            if (bcsmEvent.getLegID() != null) {
                xml.add((Object)((LegIDImpl)bcsmEvent.getLegID()), BCSMEventImpl.LEG_ID, LegIDImpl.class);
            }
            if (bcsmEvent.getDpSpecificCriteria() != null) {
                xml.add((Object)((DpSpecificCriteriaImpl)bcsmEvent.getDpSpecificCriteria()), BCSMEventImpl.DP_SPECIFIC_CRITERIA, DpSpecificCriteriaImpl.class);
            }
            if (bcsmEvent.getAutomaticRearm()) {
                xml.add((Object)bcsmEvent.getAutomaticRearm(), BCSMEventImpl.AUTOMATIC_REARM, Boolean.class);
            }
        }
    };

    public BCSMEventImpl() {
        super("BCSMEvent");
    }

    public BCSMEventImpl(EventTypeBCSM eventTypeBCSM, MonitorMode monitorMode, LegID legID, DpSpecificCriteria dpSpecificCriteria, boolean automaticRearm) {
        super("BCSMEvent");
        this.eventTypeBCSM = eventTypeBCSM;
        this.monitorMode = monitorMode;
        this.legID = legID;
        this.dpSpecificCriteria = dpSpecificCriteria;
        this.automaticRearm = automaticRearm;
    }

    public EventTypeBCSM getEventTypeBCSM() {
        return this.eventTypeBCSM;
    }

    public MonitorMode getMonitorMode() {
        return this.monitorMode;
    }

    public LegID getLegID() {
        return this.legID;
    }

    public DpSpecificCriteria getDpSpecificCriteria() {
        return this.dpSpecificCriteria;
    }

    public boolean getAutomaticRearm() {
        return this.automaticRearm;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, MAPParsingComponentException, IOException, AsnException, INAPParsingComponentException {
        this.eventTypeBCSM = null;
        this.monitorMode = null;
        this.legID = null;
        this.dpSpecificCriteria = null;
        this.automaticRearm = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        int i1 = (int)ais.readInteger();
                        this.eventTypeBCSM = EventTypeBCSM.getInstance((int)i1);
                        break;
                    }
                    case 1: {
                        int i1 = (int)ais.readInteger();
                        this.monitorMode = MonitorMode.getInstance((int)i1);
                        break;
                    }
                    case 2: {
                        this.legID = new LegIDImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((LegIDImpl)this.legID).decodeAll(ais2);
                        break;
                    }
                    case 30: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.dpSpecificCriteria = new DpSpecificCriteriaImpl();
                        ((DpSpecificCriteriaImpl)this.dpSpecificCriteria).decodeAll(ais2);
                        break;
                    }
                    case 50: {
                        ais.readNull();
                        this.automaticRearm = true;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.eventTypeBCSM == null || this.monitorMode == null) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": eventTypeBCSM and monitorMode are mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            int pos;
            if (this.eventTypeBCSM == null || this.monitorMode == null) {
                throw new CAPException("Error while encoding " + this._PrimitiveName + ": eventTypeBCSM and monitorMode must not be null");
            }
            aos.writeInteger(2, 0, (long)this.eventTypeBCSM.getCode());
            aos.writeInteger(2, 1, (long)this.monitorMode.getCode());
            if (this.legID != null) {
                aos.writeTag(2, false, 2);
                pos = aos.StartContentDefiniteLength();
                ((LegIDImpl)this.legID).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.dpSpecificCriteria != null) {
                aos.writeTag(2, false, 30);
                pos = aos.StartContentDefiniteLength();
                ((DpSpecificCriteriaImpl)this.dpSpecificCriteria).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.automaticRearm) {
                aos.writeNull(2, 50);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (INAPException e) {
            throw new CAPException("INAPException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.eventTypeBCSM != null) {
            sb.append("eventTypeBCSM=");
            sb.append(this.eventTypeBCSM);
        }
        if (this.monitorMode != null) {
            sb.append(", monitorMode=");
            sb.append(this.monitorMode);
        }
        if (this.legID != null) {
            sb.append(", legID=");
            sb.append(this.legID.toString());
        }
        if (this.dpSpecificCriteria != null) {
            sb.append(", dpSpecificCriteria=");
            sb.append(this.dpSpecificCriteria.toString());
        }
        if (this.automaticRearm) {
            sb.append(", automaticRearm");
        }
        sb.append("]");
        return sb.toString();
    }
}

