/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.isup;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CalledPartyNumberCap;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.CalledPartyNumberImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.CalledPartyNumber;

public class CalledPartyNumberCapImpl
implements CalledPartyNumberCap,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "CalledPartyNumberCap";
    private static final String ISUP_CALLED_PARTY_NUMBER_XML = "isupCalledPartyNumber";
    private byte[] data;
    protected static final XMLFormat<CalledPartyNumberCapImpl> CALLED_PARTY_NUMBER_CAP_XML = new XMLFormat<CalledPartyNumberCapImpl>(CalledPartyNumberCapImpl.class){

        public void read(XMLFormat.InputElement xml, CalledPartyNumberCapImpl calledPartyNumber) throws XMLStreamException {
            try {
                calledPartyNumber.setCalledPartyNumber((CalledPartyNumber)xml.get(CalledPartyNumberCapImpl.ISUP_CALLED_PARTY_NUMBER_XML, CalledPartyNumberImpl.class));
            }
            catch (CAPException e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void write(CalledPartyNumberCapImpl calledPartyNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                xml.add((Object)((CalledPartyNumberImpl)calledPartyNumber.getCalledPartyNumber()), CalledPartyNumberCapImpl.ISUP_CALLED_PARTY_NUMBER_XML, CalledPartyNumberImpl.class);
            }
            catch (CAPException e) {
                throw new XMLStreamException((Throwable)e);
            }
        }
    };

    public CalledPartyNumberCapImpl() {
    }

    public CalledPartyNumberCapImpl(byte[] data) {
        this.data = data;
    }

    public CalledPartyNumberCapImpl(CalledPartyNumber calledPartyNumber) throws CAPException {
        this.setCalledPartyNumber(calledPartyNumber);
    }

    public void setCalledPartyNumber(CalledPartyNumber calledPartyNumber) throws CAPException {
        if (calledPartyNumber == null) {
            throw new CAPException("The calledPartyNumber parameter must not be null");
        }
        try {
            this.data = ((CalledPartyNumberImpl)calledPartyNumber).encode();
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding calledPartyNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public CalledPartyNumber getCalledPartyNumber() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        try {
            CalledPartyNumberImpl ln = new CalledPartyNumberImpl();
            ln.decode(this.data);
            return ln;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding CalledPartyNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getTag() throws CAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 2 || this.data.length > 18) {
            throw new CAPParsingComponentException("Error while decoding CalledPartyNumberCap: data must be from 2 to 18 bytes length, found: " + this.data.length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CalledPartyNumberCap: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("data field must not be null");
        }
        if (this.data.length < 2 && this.data.length > 18) {
            throw new CAPException("data field length must be from 2 to 18");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
            try {
                CalledPartyNumber cpn = this.getCalledPartyNumber();
                sb.append(", ");
                sb.append(cpn.toString());
            }
            catch (CAPException cAPException) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

