/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.gap;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.gap.GapOnService;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;

public class GapOnServiceImpl
extends SequenceBase
implements GapOnService {
    public static final int _ID_serviceKey = 0;
    private static final String SERVICE_KEY = "serviceKey";
    private int serviceKey;
    protected static final XMLFormat<GapOnServiceImpl> GAP_ON_SERVICE_XML = new XMLFormat<GapOnServiceImpl>(GapOnServiceImpl.class){

        public void read(XMLFormat.InputElement xml, GapOnServiceImpl gapOnServiceImpl) throws XMLStreamException {
            gapOnServiceImpl.serviceKey = (Integer)xml.get(GapOnServiceImpl.SERVICE_KEY, Integer.class);
        }

        public void write(GapOnServiceImpl gapOnServiceImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.add((Object)gapOnServiceImpl.getServiceKey(), GapOnServiceImpl.SERVICE_KEY, Integer.class);
        }
    };

    public GapOnServiceImpl() {
        super("GapOnService");
    }

    public GapOnServiceImpl(int serviceKey) {
        super("GapOnService");
        this.serviceKey = serviceKey;
    }

    public int getServiceKey() {
        return this.serviceKey;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws IOException, AsnException, CAPParsingComponentException {
        this.serviceKey = 0;
        boolean foundServiceKey = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block3: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.serviceKey = (int)ais.readInteger();
                        foundServiceKey = true;
                        continue block3;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (!foundServiceKey) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": serviceKey is mandatory", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            asnOs.writeInteger(2, 0, (long)this.serviceKey);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("serviceKey=");
        sb.append(this.serviceKey);
        sb.append("]");
        return sb.toString();
    }
}

