/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.io;

import org.mlflow_project.apachehttp.HttpRequest;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.impl.io.DefaultHttpRequestWriter;
import org.mlflow_project.apachehttp.io.HttpMessageWriter;
import org.mlflow_project.apachehttp.io.HttpMessageWriterFactory;
import org.mlflow_project.apachehttp.io.SessionOutputBuffer;
import org.mlflow_project.apachehttp.message.BasicLineFormatter;
import org.mlflow_project.apachehttp.message.LineFormatter;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestWriterFactory
implements HttpMessageWriterFactory<HttpRequest> {
    public static final DefaultHttpRequestWriterFactory INSTANCE = new DefaultHttpRequestWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpRequestWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpRequestWriterFactory() {
        this(null);
    }

    @Override
    public HttpMessageWriter<HttpRequest> create(SessionOutputBuffer buffer) {
        return new DefaultHttpRequestWriter(buffer, this.lineFormatter);
    }
}

