/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.io;

import org.mlflow_project.apachehttp.HttpResponse;
import org.mlflow_project.apachehttp.HttpResponseFactory;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.config.MessageConstraints;
import org.mlflow_project.apachehttp.impl.DefaultHttpResponseFactory;
import org.mlflow_project.apachehttp.impl.io.DefaultHttpResponseParser;
import org.mlflow_project.apachehttp.io.HttpMessageParser;
import org.mlflow_project.apachehttp.io.HttpMessageParserFactory;
import org.mlflow_project.apachehttp.io.SessionInputBuffer;
import org.mlflow_project.apachehttp.message.BasicLineParser;
import org.mlflow_project.apachehttp.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

