/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.cookie;

import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.cookie.CommonCookieAttributeHandler;
import org.mlflow_project.apachehttp.cookie.Cookie;
import org.mlflow_project.apachehttp.cookie.CookieOrigin;
import org.mlflow_project.apachehttp.cookie.CookieRestrictionViolationException;
import org.mlflow_project.apachehttp.cookie.MalformedCookieException;
import org.mlflow_project.apachehttp.cookie.SetCookie;
import org.mlflow_project.apachehttp.impl.cookie.AbstractCookieAttributeHandler;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

