/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.token;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import org.mitre.jwt.assertion.AssertionValidator;
import org.mitre.oauth2.assertion.AssertionOAuth2RequestFactory;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.openid.connect.assertion.JWTBearerAssertionAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

@Component(value="jwtAssertionTokenGranter")
public class JWTAssertionTokenGranter
extends AbstractTokenGranter {
    private static final String grantType = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    @Autowired
    @Qualifier(value="jwtAssertionValidator")
    private AssertionValidator validator;
    @Autowired
    private AssertionOAuth2RequestFactory assertionFactory;

    @Autowired
    public JWTAssertionTokenGranter(OAuth2TokenEntityService tokenServices, ClientDetailsEntityService clientDetailsService, OAuth2RequestFactory requestFactory) {
        super((AuthorizationServerTokenServices)tokenServices, (ClientDetailsService)clientDetailsService, requestFactory, grantType);
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) throws AuthenticationException, InvalidTokenException {
        try {
            String incomingAssertionValue = (String)tokenRequest.getRequestParameters().get("assertion");
            JWT assertion = JWTParser.parse((String)incomingAssertionValue);
            if (this.validator.isValid(assertion)) {
                return new OAuth2Authentication(this.assertionFactory.createOAuth2Request(client, tokenRequest, assertion), (Authentication)new JWTBearerAssertionAuthenticationToken(assertion, client.getAuthorities()));
            }
            this.logger.warn((Object)"Incoming assertion did not pass validator, rejecting");
            return null;
        }
        catch (ParseException e) {
            this.logger.warn((Object)"Unable to parse incoming assertion");
            return null;
        }
    }
}

