/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.security.Principal;
import java.util.Collection;
import org.mitre.openid.connect.model.BlacklistedSite;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/blacklist"})
@PreAuthorize(value="hasRole('ROLE_ADMIN')")
public class BlacklistAPI {
    public static final String URL = "api/blacklist";
    @Autowired
    private BlacklistedSiteService blacklistService;
    private static final Logger logger = LoggerFactory.getLogger(BlacklistAPI.class);
    private Gson gson = new Gson();
    private JsonParser parser = new JsonParser();

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String getAllBlacklistedSites(ModelMap m) {
        Collection all = this.blacklistService.getAll();
        m.put((Object)"entity", (Object)all);
        return "jsonEntityView";
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String addNewBlacklistedSite(@RequestBody String jsonString, ModelMap m, Principal p) {
        BlacklistedSite blacklist = null;
        try {
            JsonObject json = this.parser.parse(jsonString).getAsJsonObject();
            blacklist = (BlacklistedSite)this.gson.fromJson((JsonElement)json, BlacklistedSite.class);
            BlacklistedSite newBlacklist = this.blacklistService.saveNew(blacklist);
            m.put((Object)"entity", (Object)newBlacklist);
        }
        catch (JsonSyntaxException e) {
            logger.error("addNewBlacklistedSite failed due to JsonSyntaxException: ", (Throwable)e);
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)"Could not save new blacklisted site. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("addNewBlacklistedSite failed due to IllegalStateException", (Throwable)e);
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)"Could not save new blacklisted site. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String updateBlacklistedSite(@PathVariable(value="id") Long id, @RequestBody String jsonString, ModelMap m, Principal p) {
        BlacklistedSite blacklist = null;
        try {
            JsonObject json = this.parser.parse(jsonString).getAsJsonObject();
            blacklist = (BlacklistedSite)this.gson.fromJson((JsonElement)json, BlacklistedSite.class);
        }
        catch (JsonSyntaxException e) {
            logger.error("updateBlacklistedSite failed due to JsonSyntaxException", (Throwable)e);
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)"Could not update blacklisted site. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("updateBlacklistedSite failed due to IllegalStateException", (Throwable)e);
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)"Could not update blacklisted site. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        BlacklistedSite oldBlacklist = this.blacklistService.getById(id);
        if (oldBlacklist == null) {
            logger.error("updateBlacklistedSite failed; blacklist with id " + id + " could not be found");
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("Could not update blacklisted site. The requested blacklist with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        BlacklistedSite newBlacklist = this.blacklistService.update(oldBlacklist, blacklist);
        m.put((Object)"entity", (Object)newBlacklist);
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public String deleteBlacklistedSite(@PathVariable(value="id") Long id, ModelMap m) {
        BlacklistedSite blacklist = this.blacklistService.getById(id);
        if (blacklist == null) {
            logger.error("deleteBlacklistedSite failed; blacklist with id " + id + " could not be found");
            m.put((Object)"errorMessage", (Object)("Could not delete bladklist. The requested bladklist with id " + id + " could not be found."));
            return "jsonErrorView";
        }
        m.put((Object)"code", (Object)HttpStatus.OK);
        this.blacklistService.remove(blacklist);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getBlacklistedSite(@PathVariable(value="id") Long id, ModelMap m) {
        BlacklistedSite blacklist = this.blacklistService.getById(id);
        if (blacklist == null) {
            logger.error("getBlacklistedSite failed; blacklist with id " + id + " could not be found");
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("Could not delete bladklist. The requested bladklist with id " + id + " could not be found."));
            return "jsonErrorView";
        }
        m.put((Object)"entity", (Object)blacklist);
        return "jsonEntityView";
    }
}

