/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.mitre.openid.connect.service.StatsService;
import org.mitre.openid.connect.service.WhitelistedSiteService;
import org.mitre.uma.model.ResourceSet;
import org.mitre.uma.service.ResourceSetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class DefaultOAuth2ClientDetailsEntityService
implements ClientDetailsEntityService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOAuth2ClientDetailsEntityService.class);
    @Autowired
    private OAuth2ClientRepository clientRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private WhitelistedSiteService whitelistedSiteService;
    @Autowired
    private BlacklistedSiteService blacklistedSiteService;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private StatsService statsService;
    @Autowired
    private ResourceSetService resourceSetService;
    @Autowired
    private ConfigurationPropertiesBean config;
    private LoadingCache<String, List<String>> sectorRedirects = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new SectorIdentifierLoader((HttpClient)HttpClientBuilder.create().useSystemProperties().build()));

    public ClientDetailsEntity saveNewClient(ClientDetailsEntity client) {
        if (client.getId() != null) {
            throw new IllegalArgumentException("Tried to save a new client with an existing ID: " + client.getId());
        }
        if (client.getRegisteredRedirectUri() != null) {
            for (String uri : client.getRegisteredRedirectUri()) {
                if (!this.blacklistedSiteService.isBlacklisted(uri)) continue;
                throw new IllegalArgumentException("Client URI is blacklisted: " + uri);
            }
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.generateClientId(client);
        }
        this.ensureRefreshTokenConsistency(client);
        this.ensureKeyConsistency(client);
        this.checkHeartMode(client);
        client.setCreatedAt(new Date());
        this.checkSectorIdentifierUri(client);
        this.ensureNoReservedScopes(client);
        ClientDetailsEntity c = this.clientRepository.saveClient(client);
        this.statsService.resetCache();
        return c;
    }

    private void ensureKeyConsistency(ClientDetailsEntity client) {
        if (client.getJwksUri() != null && client.getJwks() != null) {
            throw new IllegalArgumentException("A client cannot have both JWKS URI and JWKS value");
        }
    }

    private void ensureNoReservedScopes(ClientDetailsEntity client) {
        Set requestedScope = this.scopeService.fromStrings(client.getScope());
        requestedScope = this.scopeService.removeReservedScopes(requestedScope);
        client.setScope(this.scopeService.toStrings(requestedScope));
    }

    private void checkSectorIdentifierUri(ClientDetailsEntity client) {
        if (!Strings.isNullOrEmpty((String)client.getSectorIdentifierUri())) {
            try {
                List redirects = (List)this.sectorRedirects.get((Object)client.getSectorIdentifierUri());
                if (client.getRegisteredRedirectUri() != null) {
                    for (String uri : client.getRegisteredRedirectUri()) {
                        if (redirects.contains(uri)) continue;
                        throw new IllegalArgumentException("Requested Redirect URI " + uri + " is not listed at sector identifier " + redirects);
                    }
                }
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                throw new IllegalArgumentException("Unable to load sector identifier URI " + client.getSectorIdentifierUri() + ": " + e.getMessage());
            }
        }
    }

    private void ensureRefreshTokenConsistency(ClientDetailsEntity client) {
        if (client.getAuthorizedGrantTypes().contains("refresh_token") || client.getScope().contains("offline_access")) {
            client.getScope().add("offline_access");
            client.getAuthorizedGrantTypes().add("refresh_token");
        }
    }

    private void checkHeartMode(ClientDetailsEntity client) {
        if (this.config.isHeartMode()) {
            if (client.getGrantTypes().contains("authorization_code")) {
                if (client.getGrantTypes().contains("implicit") || client.getGrantTypes().contains("client_credentials")) {
                    throw new IllegalArgumentException("[HEART mode] Incompatible grant types");
                }
                if (client.getTokenEndpointAuthMethod() == null || !client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
                    throw new IllegalArgumentException("[HEART mode] Authorization code clients must use the private_key authentication method");
                }
                if (client.getRedirectUris().isEmpty()) {
                    throw new IllegalArgumentException("[HEART mode] Authorization code clients must register at least one redirect URI");
                }
            }
            if (client.getGrantTypes().contains("implicit")) {
                if (client.getGrantTypes().contains("authorization_code") || client.getGrantTypes().contains("client_credentials") || client.getGrantTypes().contains("refresh_token")) {
                    throw new IllegalArgumentException("[HEART mode] Incompatible grant types");
                }
                if (client.getTokenEndpointAuthMethod() == null || !client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.NONE)) {
                    throw new IllegalArgumentException("[HEART mode] Implicit clients must use the none authentication method");
                }
                if (client.getRedirectUris().isEmpty()) {
                    throw new IllegalArgumentException("[HEART mode] Implicit clients must register at least one redirect URI");
                }
            }
            if (client.getGrantTypes().contains("client_credentials")) {
                if (client.getGrantTypes().contains("authorization_code") || client.getGrantTypes().contains("implicit") || client.getGrantTypes().contains("refresh_token")) {
                    throw new IllegalArgumentException("[HEART mode] Incompatible grant types");
                }
                if (client.getTokenEndpointAuthMethod() == null || !client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
                    throw new IllegalArgumentException("[HEART mode] Client credentials clients must use the private_key authentication method");
                }
                if (!client.getRedirectUris().isEmpty()) {
                    throw new IllegalArgumentException("[HEART mode] Client credentials clients must not register a redirect URI");
                }
            }
            if (client.getGrantTypes().contains("password")) {
                throw new IllegalArgumentException("[HEART mode] Password grant type is forbidden");
            }
            if (!Strings.isNullOrEmpty((String)client.getClientSecret())) {
                throw new IllegalArgumentException("[HEART mode] Client secrets are not allowed");
            }
            if (client.getJwks() == null && Strings.isNullOrEmpty((String)client.getJwksUri())) {
                throw new IllegalArgumentException("[HEART mode] All clients must have a key registered");
            }
            if (client.getRedirectUris() != null && !client.getRedirectUris().isEmpty()) {
                boolean localhost = false;
                boolean remoteHttps = false;
                boolean customScheme = false;
                for (String uri : client.getRedirectUris()) {
                    UriComponents components = UriComponentsBuilder.fromUriString((String)uri).build();
                    if (components.getScheme() == null) {
                        customScheme = true;
                        continue;
                    }
                    if (components.getScheme().equals("http")) {
                        if (components.getHost().equals("localhost") || components.getHost().equals("127.0.0.1")) {
                            localhost = true;
                            continue;
                        }
                        throw new IllegalArgumentException("[HEART mode] Can't have an http redirect URI on non-local host");
                    }
                    if (components.getScheme().equals("https")) {
                        remoteHttps = true;
                        continue;
                    }
                    customScheme = true;
                }
                if (!(localhost ^ remoteHttps ^ customScheme) || localhost && remoteHttps && customScheme) {
                    throw new IllegalArgumentException("[HEART mode] Can't have more than one class of redirect URI");
                }
            }
        }
    }

    public ClientDetailsEntity getClientById(Long id) {
        ClientDetailsEntity client = this.clientRepository.getById(id);
        return client;
    }

    public ClientDetailsEntity loadClientByClientId(String clientId) throws OAuth2Exception, InvalidClientException, IllegalArgumentException {
        if (!Strings.isNullOrEmpty((String)clientId)) {
            ClientDetailsEntity client = this.clientRepository.getClientByClientId(clientId);
            if (client == null) {
                throw new InvalidClientException("Client with id " + clientId + " was not found");
            }
            return client;
        }
        throw new IllegalArgumentException("Client id must not be empty!");
    }

    public void deleteClient(ClientDetailsEntity client) throws InvalidClientException {
        if (this.clientRepository.getById(client.getId()) == null) {
            throw new InvalidClientException("Client with id " + client.getClientId() + " was not found");
        }
        this.tokenRepository.clearTokensForClient(client);
        this.approvedSiteService.clearApprovedSitesForClient((ClientDetails)client);
        WhitelistedSite whitelistedSite = this.whitelistedSiteService.getByClientId(client.getClientId());
        if (whitelistedSite != null) {
            this.whitelistedSiteService.remove(whitelistedSite);
        }
        Collection resourceSets = this.resourceSetService.getAllForClient(client);
        for (ResourceSet rs : resourceSets) {
            this.resourceSetService.remove(rs);
        }
        this.clientRepository.deleteClient(client);
        this.statsService.resetCache();
    }

    public ClientDetailsEntity updateClient(ClientDetailsEntity oldClient, ClientDetailsEntity newClient) throws IllegalArgumentException {
        if (oldClient != null && newClient != null) {
            for (String uri : newClient.getRegisteredRedirectUri()) {
                if (!this.blacklistedSiteService.isBlacklisted(uri)) continue;
                throw new IllegalArgumentException("Client URI is blacklisted: " + uri);
            }
            this.ensureRefreshTokenConsistency(newClient);
            this.ensureKeyConsistency(newClient);
            this.checkHeartMode(newClient);
            this.checkSectorIdentifierUri(newClient);
            this.ensureNoReservedScopes(newClient);
            return this.clientRepository.updateClient(oldClient.getId(), newClient);
        }
        throw new IllegalArgumentException("Neither old client or new client can be null!");
    }

    public Collection<ClientDetailsEntity> getAllClients() {
        return this.clientRepository.getAllClients();
    }

    public ClientDetailsEntity generateClientId(ClientDetailsEntity client) {
        client.setClientId(UUID.randomUUID().toString());
        return client;
    }

    public ClientDetailsEntity generateClientSecret(ClientDetailsEntity client) {
        if (this.config.isHeartMode()) {
            logger.error("[HEART mode] Can't generate a client secret, skipping step; client won't be saved due to invalid configuration");
            client.setClientSecret(null);
        } else {
            client.setClientSecret(Base64.encodeBase64URLSafeString((byte[])new BigInteger(512, new SecureRandom()).toByteArray()).replace("=", ""));
        }
        return client;
    }

    private class SectorIdentifierLoader
    extends CacheLoader<String, List<String>> {
        private HttpComponentsClientHttpRequestFactory httpFactory;
        private RestTemplate restTemplate;
        private JsonParser parser = new JsonParser();

        SectorIdentifierLoader(HttpClient httpClient) {
            this.httpFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
            this.restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
        }

        public List<String> load(String key) throws Exception {
            String jsonString;
            JsonElement json;
            if (!key.startsWith("https")) {
                if (DefaultOAuth2ClientDetailsEntityService.this.config.isForceHttps()) {
                    throw new IllegalArgumentException("Sector identifier must start with https: " + key);
                }
                logger.error("Sector identifier doesn't start with https, loading anyway...");
            }
            if ((json = this.parser.parse(jsonString = (String)this.restTemplate.getForObject(key, String.class, new Object[0]))).isJsonArray()) {
                ArrayList<String> redirectUris = new ArrayList<String>();
                for (JsonElement el : json.getAsJsonArray()) {
                    redirectUris.add(el.getAsString());
                }
                logger.info("Found " + redirectUris + " for sector " + key);
                return redirectUris;
            }
            throw new IllegalArgumentException("JSON Format Error");
        }
    }
}

