/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.filter;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class MultiUrlRequestMatcher
implements RequestMatcher {
    private final Set<RequestMatcher> matchers;

    public MultiUrlRequestMatcher(Set<String> filterProcessesUrls) {
        this.matchers = new HashSet<RequestMatcher>(filterProcessesUrls.size());
        for (String filterProcessesUrl : filterProcessesUrls) {
            Assert.hasLength((String)filterProcessesUrl, (String)"filterProcessesUrl must be specified");
            Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)filterProcessesUrl), (String)(filterProcessesUrl + " isn't a valid URL"));
            this.matchers.add((RequestMatcher)new AntPathRequestMatcher(filterProcessesUrl));
        }
    }

    public boolean matches(HttpServletRequest request) {
        for (RequestMatcher matcher : this.matchers) {
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }
}

