/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.matrix.olm.CommonSerializeUtils;
import org.matrix.olm.OlmAccount;
import org.matrix.olm.OlmException;
import org.matrix.olm.OlmMessage;

public class OlmSession
extends CommonSerializeUtils
implements Serializable {
    private static final long serialVersionUID = -8975488639186976419L;
    private static final String LOG_TAG = "OlmSession";
    private transient long mNativeId;

    public OlmSession() throws OlmException {
        try {
            this.mNativeId = this.createNewSessionJni();
        }
        catch (Exception e) {
            throw new OlmException(400, e.getMessage());
        }
    }

    private native long createNewSessionJni();

    long getOlmSessionId() {
        return this.mNativeId;
    }

    private native void releaseSessionJni();

    public void releaseSession() {
        if (0L != this.mNativeId) {
            this.releaseSessionJni();
        }
        this.mNativeId = 0L;
    }

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public void initOutboundSession(OlmAccount aAccount, String aTheirIdentityKey, String aTheirOneTimeKey) throws OlmException {
        if (null == aAccount || TextUtils.isEmpty((CharSequence)aTheirIdentityKey) || TextUtils.isEmpty((CharSequence)aTheirOneTimeKey)) {
            Log.e((String)LOG_TAG, (String)"## initOutboundSession(): invalid input parameters");
            throw new OlmException(401, "invalid input parameters");
        }
        try {
            this.initOutboundSessionJni(aAccount.getOlmAccountId(), aTheirIdentityKey.getBytes("UTF-8"), aTheirOneTimeKey.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## initOutboundSession(): " + e.getMessage()));
            throw new OlmException(401, e.getMessage());
        }
    }

    private native void initOutboundSessionJni(long var1, byte[] var3, byte[] var4);

    public void initInboundSession(OlmAccount aAccount, String aPreKeyMsg) throws OlmException {
        if (null == aAccount || TextUtils.isEmpty((CharSequence)aPreKeyMsg)) {
            Log.e((String)LOG_TAG, (String)"## initInboundSession(): invalid input parameters");
            throw new OlmException(402, "invalid input parameters");
        }
        try {
            this.initInboundSessionJni(aAccount.getOlmAccountId(), aPreKeyMsg.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## initInboundSession(): " + e.getMessage()));
            throw new OlmException(402, e.getMessage());
        }
    }

    private native void initInboundSessionJni(long var1, byte[] var3);

    public void initInboundSessionFrom(OlmAccount aAccount, String aTheirIdentityKey, String aPreKeyMsg) throws OlmException {
        if (null == aAccount || TextUtils.isEmpty((CharSequence)aPreKeyMsg)) {
            Log.e((String)LOG_TAG, (String)"## initInboundSessionFrom(): invalid input parameters");
            throw new OlmException(403, "invalid input parameters");
        }
        try {
            this.initInboundSessionFromIdKeyJni(aAccount.getOlmAccountId(), aTheirIdentityKey.getBytes("UTF-8"), aPreKeyMsg.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## initInboundSessionFrom(): " + e.getMessage()));
            throw new OlmException(403, e.getMessage());
        }
    }

    private native void initInboundSessionFromIdKeyJni(long var1, byte[] var3, byte[] var4);

    public String sessionIdentifier() throws OlmException {
        try {
            byte[] buffer = this.getSessionIdentifierJni();
            if (null != buffer) {
                return new String(buffer, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## sessionIdentifier(): " + e.getMessage()));
            throw new OlmException(406, e.getMessage());
        }
        return null;
    }

    private native byte[] getSessionIdentifierJni();

    public boolean matchesInboundSession(String aOneTimeKeyMsg) {
        boolean retCode = false;
        try {
            retCode = this.matchesInboundSessionJni(aOneTimeKeyMsg.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## matchesInboundSession(): failed " + e.getMessage()));
        }
        return retCode;
    }

    private native boolean matchesInboundSessionJni(byte[] var1);

    public boolean matchesInboundSessionFrom(String aTheirIdentityKey, String aOneTimeKeyMsg) {
        boolean retCode = false;
        try {
            retCode = this.matchesInboundSessionFromIdKeyJni(aTheirIdentityKey.getBytes("UTF-8"), aOneTimeKeyMsg.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## matchesInboundSessionFrom(): failed " + e.getMessage()));
        }
        return retCode;
    }

    private native boolean matchesInboundSessionFromIdKeyJni(byte[] var1, byte[] var2);

    public OlmMessage encryptMessage(String aClearMsg) throws OlmException {
        if (null == aClearMsg) {
            return null;
        }
        OlmMessage encryptedMsgRetValue = new OlmMessage();
        try {
            byte[] clearMsgBuffer = aClearMsg.getBytes("UTF-8");
            byte[] encryptedMessageBuffer = this.encryptMessageJni(clearMsgBuffer, encryptedMsgRetValue);
            Arrays.fill(clearMsgBuffer, (byte)0);
            if (null != encryptedMessageBuffer) {
                encryptedMsgRetValue.mCipherText = new String(encryptedMessageBuffer, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## encryptMessage(): failed " + e.getMessage()));
            throw new OlmException(404, e.getMessage());
        }
        return encryptedMsgRetValue;
    }

    private native byte[] encryptMessageJni(byte[] var1, OlmMessage var2);

    public String decryptMessage(OlmMessage aEncryptedMsg) throws OlmException {
        if (null == aEncryptedMsg) {
            return null;
        }
        try {
            byte[] plaintextBuffer = this.decryptMessageJni(aEncryptedMsg);
            String plaintext = new String(plaintextBuffer, "UTF-8");
            Arrays.fill(plaintextBuffer, (byte)0);
            return plaintext;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## decryptMessage(): failed " + e.getMessage()));
            throw new OlmException(405, e.getMessage());
        }
    }

    private native byte[] decryptMessageJni(OlmMessage var1);

    private void writeObject(ObjectOutputStream aOutStream) throws IOException {
        this.serialize(aOutStream);
    }

    private void readObject(ObjectInputStream aInStream) throws Exception {
        this.deserialize(aInStream);
    }

    @Override
    protected byte[] serialize(byte[] aKey, StringBuffer aErrorMsg) {
        byte[] pickleRetValue = null;
        if (null == aErrorMsg) {
            Log.e((String)LOG_TAG, (String)"## serializeDataWithKey(): invalid parameter - aErrorMsg=null");
        } else if (null == aKey) {
            aErrorMsg.append("Invalid input parameters in serializeDataWithKey()");
        } else {
            aErrorMsg.setLength(0);
            try {
                pickleRetValue = this.serializeJni(aKey);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## serializeDataWithKey(): failed " + e.getMessage()));
                aErrorMsg.append(e.getMessage());
            }
        }
        return pickleRetValue;
    }

    private native byte[] serializeJni(byte[] var1);

    @Override
    protected void deserialize(byte[] aSerializedData, byte[] aKey) throws Exception {
        String errorMsg = null;
        try {
            if (null == aSerializedData || null == aKey) {
                Log.e((String)LOG_TAG, (String)"## deserialize(): invalid input parameters");
                errorMsg = "invalid input parameters";
            } else {
                this.mNativeId = this.deserializeJni(aSerializedData, aKey);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## deserialize() failed " + e.getMessage()));
            errorMsg = e.getMessage();
        }
        if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
            this.releaseSession();
            throw new OlmException(101, errorMsg);
        }
    }

    private native long deserializeJni(byte[] var1, byte[] var2);
}

