/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.util.Log;
import java.io.UnsupportedEncodingException;
import org.matrix.olm.OlmException;

public class OlmSAS {
    private static final String LOG_TAG = OlmSAS.class.getName();
    private transient long mNativeId;
    private String theirPublicKey = null;

    public OlmSAS() throws OlmException {
        try {
            this.mNativeId = this.createNewSASJni();
        }
        catch (Exception e) {
            throw new OlmException(900, e.getMessage());
        }
    }

    public String getPublicKey() throws OlmException {
        try {
            byte[] buffer = this.getPubKeyJni();
            if (null != buffer) {
                return new String(buffer, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## sessionIdentifier(): " + e.getMessage()));
            throw new OlmException(901, e.getMessage());
        }
        return null;
    }

    public void setTheirPublicKey(String otherPkey) throws OlmException {
        try {
            this.setTheirPubKey(otherPkey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OlmException(901, e.getMessage());
        }
        this.theirPublicKey = otherPkey;
    }

    public byte[] generateShortCode(String info, int byteNumber) throws OlmException {
        if (this.theirPublicKey == null || this.theirPublicKey.isEmpty()) {
            throw new OlmException(902, "call setTheirPublicKey first");
        }
        try {
            return this.generateShortCodeJni(info.getBytes("UTF-8"), byteNumber);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## sessionIdentifier(): " + e.getMessage()));
            throw new OlmException(903, e.getMessage());
        }
    }

    public String calculateMac(String message, String info) throws OlmException {
        try {
            byte[] bytes = this.calculateMacJni(message.getBytes("UTF-8"), info.getBytes("UTF-8"));
            if (bytes != null) {
                return new String(bytes, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OlmException(901, e.getMessage());
        }
        return null;
    }

    public String calculateMacLongKdf(String message, String info) throws OlmException {
        try {
            byte[] bytes = this.calculateMacLongKdfJni(message.getBytes("UTF-8"), info.getBytes("UTF-8"));
            if (bytes != null) {
                return new String(bytes, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OlmException(901, e.getMessage());
        }
        return null;
    }

    private native long createNewSASJni();

    private native void releaseSASJni();

    private native byte[] getPubKeyJni();

    private native void setTheirPubKey(byte[] var1);

    private native byte[] generateShortCodeJni(byte[] var1, int var2);

    private native byte[] calculateMacJni(byte[] var1, byte[] var2);

    private native byte[] calculateMacLongKdfJni(byte[] var1, byte[] var2);

    public void releaseSas() {
        if (0L != this.mNativeId) {
            this.releaseSASJni();
        }
        this.mNativeId = 0L;
    }
}

