/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.util.Log;
import java.util.Arrays;
import org.matrix.olm.OlmException;
import org.matrix.olm.OlmPkMessage;

public class OlmPkDecryption {
    private static final String LOG_TAG = "OlmPkDecryption";
    private transient long mNativeId;

    public OlmPkDecryption() throws OlmException {
        try {
            this.mNativeId = this.createNewPkDecryptionJni();
        }
        catch (Exception e) {
            throw new OlmException(700, e.getMessage());
        }
    }

    private native long createNewPkDecryptionJni();

    private native void releasePkDecryptionJni();

    public void releaseDecryption() {
        if (0L != this.mNativeId) {
            this.releasePkDecryptionJni();
        }
        this.mNativeId = 0L;
    }

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public static native int privateKeyLength();

    public String setPrivateKey(byte[] privateKey) throws OlmException {
        try {
            byte[] key = this.setPrivateKeyJni(privateKey);
            return new String(key, "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## setPrivateKey(): failed " + e.getMessage()));
            throw new OlmException(703, e.getMessage());
        }
    }

    private native byte[] setPrivateKeyJni(byte[] var1);

    public String generateKey() throws OlmException {
        try {
            byte[] key = this.generateKeyJni();
            return new String(key, "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## setRecipientKey(): failed " + e.getMessage()));
            throw new OlmException(701, e.getMessage());
        }
    }

    private native byte[] generateKeyJni();

    public byte[] privateKey() throws OlmException {
        try {
            return this.privateKeyJni();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## privateKey(): failed " + e.getMessage()));
            throw new OlmException(704, e.getMessage());
        }
    }

    private native byte[] privateKeyJni();

    public String decrypt(OlmPkMessage aMessage) throws OlmException {
        if (null == aMessage) {
            return null;
        }
        byte[] plaintextBuffer = this.decryptJni(aMessage);
        try {
            String plaintext;
            String string2 = plaintext = new String(plaintextBuffer, "UTF-8");
            return string2;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## pkDecrypt(): failed " + e.getMessage()));
            throw new OlmException(702, e.getMessage());
        }
        finally {
            Arrays.fill(plaintextBuffer, (byte)0);
        }
    }

    private native byte[] decryptJni(OlmPkMessage var1);
}

