/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.util.Log;
import java.util.Arrays;
import org.matrix.olm.OlmException;
import org.matrix.olm.OlmPkMessage;

public class OlmPkEncryption {
    private static final String LOG_TAG = "OlmPkEncryption";
    private transient long mNativeId;

    public OlmPkEncryption() throws OlmException {
        try {
            this.mNativeId = this.createNewPkEncryptionJni();
        }
        catch (Exception e) {
            throw new OlmException(600, e.getMessage());
        }
    }

    private native long createNewPkEncryptionJni();

    private native void releasePkEncryptionJni();

    public void releaseEncryption() {
        if (0L != this.mNativeId) {
            this.releasePkEncryptionJni();
        }
        this.mNativeId = 0L;
    }

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public void setRecipientKey(String aKey) throws OlmException {
        if (null == aKey) {
            return;
        }
        try {
            this.setRecipientKeyJni(aKey.getBytes("UTF-8"));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## setRecipientKey(): failed " + e.getMessage()));
            throw new OlmException(601, e.getMessage());
        }
    }

    private native void setRecipientKeyJni(byte[] var1);

    public OlmPkMessage encrypt(String aPlaintext) throws OlmException {
        if (null == aPlaintext) {
            return null;
        }
        OlmPkMessage encryptedMsgRetValue = new OlmPkMessage();
        byte[] plaintextBuffer = null;
        try {
            plaintextBuffer = aPlaintext.getBytes("UTF-8");
            byte[] ciphertextBuffer = this.encryptJni(plaintextBuffer, encryptedMsgRetValue);
            if (null != ciphertextBuffer) {
                encryptedMsgRetValue.mCipherText = new String(ciphertextBuffer, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## pkEncrypt(): failed " + e.getMessage()));
            throw new OlmException(602, e.getMessage());
        }
        finally {
            if (null != plaintextBuffer) {
                Arrays.fill(plaintextBuffer, (byte)0);
            }
        }
        return encryptedMsgRetValue;
    }

    private native byte[] encryptJni(byte[] var1, OlmPkMessage var2);
}

