/*
 * Decompiled with CFR 0.152.
 */
package org.matrix.olm;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.matrix.olm.CommonSerializeUtils;
import org.matrix.olm.OlmException;

public class OlmInboundGroupSession
extends CommonSerializeUtils
implements Serializable {
    private static final long serialVersionUID = -772028491251653253L;
    private static final String LOG_TAG = "OlmInboundGroupSession";
    private transient long mNativeId;

    public OlmInboundGroupSession(String aSessionKey) throws OlmException {
        this(aSessionKey, false);
    }

    private OlmInboundGroupSession(String aSessionKey, boolean isImported) throws OlmException {
        if (TextUtils.isEmpty((CharSequence)aSessionKey)) {
            Log.e((String)LOG_TAG, (String)"## initInboundGroupSession(): invalid session key");
            throw new OlmException(201, "invalid session key");
        }
        byte[] sessionBuffer = null;
        try {
            sessionBuffer = aSessionKey.getBytes("UTF-8");
            this.mNativeId = this.createNewSessionJni(aSessionKey.getBytes("UTF-8"), isImported);
        }
        catch (Exception e) {
            throw new OlmException(201, e.getMessage());
        }
        finally {
            if (null != sessionBuffer) {
                Arrays.fill(sessionBuffer, (byte)0);
            }
        }
    }

    private native long createNewSessionJni(byte[] var1, boolean var2);

    public static OlmInboundGroupSession importSession(String exported) throws OlmException {
        return new OlmInboundGroupSession(exported, true);
    }

    public void releaseSession() {
        if (0L != this.mNativeId) {
            this.releaseSessionJni();
        }
        this.mNativeId = 0L;
    }

    private native void releaseSessionJni();

    public boolean isReleased() {
        return 0L == this.mNativeId;
    }

    public String sessionIdentifier() throws OlmException {
        try {
            return new String(this.sessionIdentifierJni(), "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## sessionIdentifier() failed " + e.getMessage()));
            throw new OlmException(202, e.getMessage());
        }
    }

    private native byte[] sessionIdentifierJni();

    public long getFirstKnownIndex() throws OlmException {
        long index = 0L;
        try {
            index = this.firstKnownIndexJni();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## getFirstKnownIndex() failed " + e.getMessage()));
            throw new OlmException(204, e.getMessage());
        }
        return index;
    }

    private native long firstKnownIndexJni();

    public boolean isVerified() throws OlmException {
        boolean isVerified;
        try {
            isVerified = this.isVerifiedJni();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## isVerified() failed " + e.getMessage()));
            throw new OlmException(205, e.getMessage());
        }
        return isVerified;
    }

    private native boolean isVerifiedJni();

    public String export(long messageIndex) throws OlmException {
        String result = null;
        try {
            byte[] bytesBuffer = this.exportJni(messageIndex);
            if (null != bytesBuffer) {
                result = new String(bytesBuffer, "UTF-8");
                Arrays.fill(bytesBuffer, (byte)0);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## export() failed " + e.getMessage()));
            throw new OlmException(206, e.getMessage());
        }
        return result;
    }

    private native byte[] exportJni(long var1);

    public DecryptMessageResult decryptMessage(String aEncryptedMsg) throws OlmException {
        DecryptMessageResult result = new DecryptMessageResult();
        try {
            byte[] decryptedMessageBuffer = this.decryptMessageJni(aEncryptedMsg.getBytes("UTF-8"), result);
            if (null != decryptedMessageBuffer) {
                result.mDecryptedMessage = new String(decryptedMessageBuffer, "UTF-8");
                Arrays.fill(decryptedMessageBuffer, (byte)0);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## decryptMessage() failed " + e.getMessage()));
            throw new OlmException(203, e.getMessage());
        }
        return result;
    }

    private native byte[] decryptMessageJni(byte[] var1, DecryptMessageResult var2);

    private void writeObject(ObjectOutputStream aOutStream) throws IOException {
        this.serialize(aOutStream);
    }

    private void readObject(ObjectInputStream aInStream) throws Exception {
        this.deserialize(aInStream);
    }

    @Override
    protected byte[] serialize(byte[] aKey, StringBuffer aErrorMsg) {
        byte[] pickleRetValue = null;
        if (null == aErrorMsg) {
            Log.e((String)LOG_TAG, (String)"## serialize(): invalid parameter - aErrorMsg=null");
        } else if (null == aKey) {
            aErrorMsg.append("Invalid input parameters in serialize()");
        } else {
            aErrorMsg.setLength(0);
            try {
                pickleRetValue = this.serializeJni(aKey);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)("## serialize() failed " + e.getMessage()));
                aErrorMsg.append(e.getMessage());
            }
        }
        return pickleRetValue;
    }

    private native byte[] serializeJni(byte[] var1);

    @Override
    protected void deserialize(byte[] aSerializedData, byte[] aKey) throws Exception {
        String errorMsg = null;
        try {
            if (null == aSerializedData || null == aKey) {
                Log.e((String)LOG_TAG, (String)"## deserialize(): invalid input parameters");
                errorMsg = "invalid input parameters";
            } else {
                this.mNativeId = this.deserializeJni(aSerializedData, aKey);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("## deserialize() failed " + e.getMessage()));
            errorMsg = e.getMessage();
        }
        if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
            this.releaseSession();
            throw new OlmException(101, errorMsg);
        }
    }

    private native long deserializeJni(byte[] var1, byte[] var2);

    public static class DecryptMessageResult {
        public String mDecryptedMessage;
        public long mIndex;
    }
}

