/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.PrimesCache;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;

public final class mXparser {
    public static final String VERSION = "5.0.2";
    public static final String VERSION_CODE_NAME = "Leonis";
    public static final String VERSION_NAME = "5.0.2 Leonis";
    public static final String BUIT_FOR = "JDK 8";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    private static volatile String CONSOLE_OUTPUT = "";
    private static volatile String CONSOLE_PREFIX;
    private static volatile String CONSOLE_OUTPUT_PREFIX;
    private static volatile int CONSOLE_ROW_NUMBER;
    public static volatile PrimesCache primesCache;
    public static final int PRIMES_CACHE_NOT_INITIALIZED = -1;
    private static int THREADS_NUMBER;
    static volatile boolean ulpRounding;
    static volatile boolean canonicalRounding;
    static volatile boolean almostIntRounding;
    static final int DEFAULT_MAX_RECURSION_CALLS = 200;
    static volatile int MAX_RECURSION_CALLS;
    static volatile List<String> tokensToRemove;
    static volatile List<TokenModification> tokensToModify;
    static volatile boolean degreesMode;
    static volatile boolean overrideBuiltinTokens;
    static volatile boolean impliedMultiplicationMode;
    static volatile boolean unicodeKeyWordsEnabled;
    static boolean attemptToFixExpStrEnabled;
    static volatile int optionsChangesetNumber;
    private static volatile boolean cancelCurrentCalculationFlag;
    static volatile Expression mXparserExp;
    public static final String LICENSE = "mXparser - version 5.0.2\nCopyright 2010 - 2022 MARIUSZ GROMADA. All rights reserved.\n\nPRODUCT: MathParser.org-mXparser\nLICENSE: DUAL LICENSE \n\nSOFTWARE means source code and/or binary form and/or documentation.\n\nBY INSTALLING, COPYING, OR OTHERWISE USING THE SOFTWARE, YOU AGREE TO BE\nBOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.\n\nMARIUSZ GROMADA provides MathParser.org-mXparser SOFTWARE under the\nDUAL LICENSE model designed to meet the needs of both Non-Commercial Use\nas well as Commercial Use.\n\nNON-COMMERCIAL USE means any use or activity where a fee is not charged\nand the purpose is not the sale of a good or service, and the use or\nactivity is not intended to produce a profit. NON-COMMERCIAL USE examples:\n\n1. Free Open-Source Software (\"FOSS\").\n2. Non-commercial use in research, scholarly and education.\n\nCOMMERCIAL USE means any use or activity where a fee is charged or the\npurpose is the sale of a good or service, or the use or activity is\nintended to produce a profit. COMMERCIAL USE examples:\n\n1. OEMs (Original Equipment Manufacturers).\n2. ISVs (Independent Software Vendors).\n3. VARs (Value Added Resellers).\n4. Other distributors that combine and distribute commercially licensed\n   software.\n\nIN CASE YOU WANT TO USE THE SOFTWARE COMMERCIALLY, YOU MUST PURCHASE\nTHE APPROPRIATE LICENSE FROM \"INFIMA IWONA GLOWACKA-GROMADA\", ONLINE\nSTORE ADDRESS: HTTPS://PAYHIP.COM/INFIMA\n\nNON-COMMERCIAL LICENSE\n\nRedistribution and use of the PRODUCT in source and/or binary forms, with\nor without modification, are permitted provided that the following\nconditions are met:\n\n1. Redistributions of source code must retain unmodified content of the\n   entire MathParser.org-mXparser DUAL LICENSE, including definition of\n   NON-COMMERCIAL USE, definition of COMMERCIAL USE, NON-COMMERCIAL\n   LICENSE conditions, COMMERCIAL LICENSE conditions, and the following\n   DISCLAIMER.\n2. Redistributions in binary form must reproduce the entire content of\n   MathParser.org-mXparser DUAL LICENSE in the documentation and/or other\n   materials provided with the distribution, including definition of\n   NON-COMMERCIAL USE, definition of COMMERCIAL USE, NON-COMMERCIAL\n   LICENSE conditions, COMMERCIAL LICENSE conditions, and the following\n   DISCLAIMER.\n\nCOMMERCIAL LICENSE\n\n 1. Before purchasing a commercial license, MARIUSZ GROMADA allows you to\n    download, install and use up to three copies of the PRODUCT to perform\n    integration tests, confirm the quality of the PRODUCT and its\n    suitability. The testing period should be limited to one month. Tests\n    should take place via test environments. The purpose of the tests must\n    not be to generate profit.\n 2. Provided that you purchased a license from \"INFIMA IWONA GLOWACKA-GROMADA\"\n    (online store address: https://payhip.com/INFIMA), you comply with all\n    below terms and conditions, and you have acknowledged and understood the\n    following DISCLAIMER, MARIUSZ GROMADA grants you a nonexclusive license\n    including the following rights:\n 3. In case you purchased a \"Single License\" You can install and use the\n    PRODUCT from one workstation.\n 4. Additional copies of the PRODUCT can be installed and used from more\n    than one workstation; however, this number is limited to the number of\n    copies purchased as per order.\n 5. In case you purchased a \"Site License\", the PRODUCT can be installed\n    and used from all workstations located at your premises.\n 6. You may incorporate the unmodified PRODUCT into your own products and\n    software.\n 7. If you purchased a license with the \"Source Code\" option, you may modify\n    the PRODUCT's source code and incorporate the modified source code into\n    your own products and / or software.\n 8. You may distribute your product and / or software with the incorporated\n    PRODUCT royalty-free.\n 9. You may make copies of the PRODUCT for backup and archival purposes.\n10. MARIUSZ GROMADA reserves all rights not expressly granted to you in\n    this agreement.\n\nCONTACT\n- e-mail: info@mathparser.org\n- website: https://mathparser.org\n- source code: https://github.com/mariuszgromada/MathParser.org-mXparser\n- online store: https://payhip.com/INFIMA\n\nDISCLAIMER\n\nTHIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA \"AS IS\" AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL MATHPARSER.ORG MARIUSZ GROMADA OR CONTRIBUTORS BE LIABLE\nFOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\nDAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\nCAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\nOR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE\nUSE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nTHE VIEWS AND CONCLUSIONS CONTAINED IN THE SOFTWARE AND DOCUMENTATION ARE\nTHOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING OFFICIAL\nPOLICIES, EITHER EXPRESSED OR IMPLIED, OF MARIUSZ GROMADA.\n";
    public static final String NAMEv10 = "1.0";
    public static final String NAMEv20 = "2.0";
    public static final String NAMEv23 = "2.3";
    public static final String NAMEv24 = "2.4";
    public static final String NAMEv30 = "3.0";
    public static final String NAMEv40 = "4.0";
    public static final String NAMEv41 = "4.1";
    public static final String NAMEv42 = "4.2";
    public static final String NAMEv43 = "4.3";
    public static final String NAMEv44 = "4.4";
    public static final String NAMEv50 = "5.0";

    public static void initPrimesCache() {
        primesCache = new PrimesCache();
    }

    public static void initPrimesCache(int mximumNumberInCache) {
        primesCache = new PrimesCache(mximumNumberInCache);
    }

    public static void initPrimesCache(PrimesCache primesCache) {
        mXparser.primesCache = primesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitPrimesCacheSuccessful() {
        if (primesCache == null) {
            return false;
        }
        PrimesCache primesCache = mXparser.primesCache;
        synchronized (primesCache) {
            return mXparser.primesCache.isInitSuccessful();
        }
    }

    public static void setNoPrimesCache() {
        primesCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxNumInPrimesCache() {
        if (primesCache != null) {
            PrimesCache primesCache = mXparser.primesCache;
            synchronized (primesCache) {
                return mXparser.primesCache.getMaxNumInCache();
            }
        }
        return -1;
    }

    public static int getThreadsNumber() {
        return THREADS_NUMBER;
    }

    public static void setDefaultThreadsNumber() {
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
    }

    public static void setThreadsNumber(int threadsNumber) {
        if (threadsNumber > 0) {
            THREADS_NUMBER = threadsNumber;
        }
    }

    public static double getFunctionValue(Expression f, Argument x, double x0) {
        x.setArgumentValue(x0);
        return f.calculate();
    }

    public static double[] arrayList2double(List<Double> numbers) {
        if (numbers == null) {
            return null;
        }
        int size = numbers.size();
        double[] newNumbers = new double[size];
        for (int i = 0; i < size; ++i) {
            newNumbers[i] = numbers.get(i);
        }
        return newNumbers;
    }

    public static double[] getFunctionValues(Expression f, Argument index, double from, double to, double delta) {
        double[] values;
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return null;
        }
        int n = 0;
        if (to >= from && delta > 0.0) {
            for (double i = from; i < to; i += delta) {
                ++n;
            }
            values = new double[++n];
            int j = 0;
            for (double i = from; i < to; i += delta) {
                values[j] = mXparser.getFunctionValue(f, index, i);
                ++j;
            }
            values[j] = mXparser.getFunctionValue(f, index, to);
        } else if (to <= from && delta < 0.0) {
            for (double i = from; i > to; i += delta) {
                ++n;
            }
            values = new double[++n];
            int j = 0;
            for (double i = from; i > to; i += delta) {
                values[j] = mXparser.getFunctionValue(f, index, i);
                ++j;
            }
            values[j] = mXparser.getFunctionValue(f, index, to);
        } else if (from == to) {
            n = 1;
            values = new double[n];
            values[0] = mXparser.getFunctionValue(f, index, from);
        } else {
            values = null;
        }
        return values;
    }

    public static void setRandomGenerator(Random randomGenerator) {
        if (randomGenerator != null) {
            ProbabilityDistributions.randomGenerator = randomGenerator;
        }
    }

    public static void setExactComparison() {
        BinaryRelations.setExactComparison();
    }

    public static void setEpsilonComparison() {
        BinaryRelations.setEpsilonComparison();
    }

    public static void setEpsilon(double epsilon) {
        BinaryRelations.setEpsilon(epsilon);
    }

    public static void setDefaultEpsilon() {
        BinaryRelations.setDefaultEpsilon();
    }

    public static double getEpsilon() {
        return BinaryRelations.getEpsilon();
    }

    public static boolean checkIfEpsilonMode() {
        return BinaryRelations.checkIfEpsilonMode();
    }

    public static boolean checkIfExactMode() {
        return BinaryRelations.checkIfExactMode();
    }

    public static void enableUlpRounding() {
        ulpRounding = true;
    }

    public static void disableUlpRounding() {
        ulpRounding = false;
    }

    public static void setUlpRounding(boolean ulpRoundingState) {
        ulpRounding = ulpRoundingState;
    }

    public static boolean checkIfUlpRounding() {
        return ulpRounding;
    }

    public static void enableCanonicalRounding() {
        canonicalRounding = true;
    }

    public static void disableCanonicalRounding() {
        canonicalRounding = false;
    }

    public static void setCanonicalRounding(boolean canonicalRoundingState) {
        canonicalRounding = canonicalRoundingState;
    }

    public static boolean checkIfCanonicalRounding() {
        return canonicalRounding;
    }

    public static void enableAlmostIntRounding() {
        almostIntRounding = true;
    }

    public static void disableAlmostIntRounding() {
        almostIntRounding = false;
    }

    public static void setAlmostIntRounding(boolean almostIntRoundingState) {
        almostIntRounding = almostIntRoundingState;
    }

    public static boolean checkIfAlmostIntRounding() {
        return almostIntRounding;
    }

    public static void setMaxAllowedRecursionDepth(int maxAllowedRecursionDepth) {
        MAX_RECURSION_CALLS = maxAllowedRecursionDepth;
    }

    public static int getMaxAllowedRecursionDepth() {
        return MAX_RECURSION_CALLS;
    }

    public static void setRadiansMode() {
        degreesMode = false;
    }

    public static void setDegreesMode() {
        degreesMode = true;
    }

    public static boolean checkIfRadiansMode() {
        return !degreesMode;
    }

    public static boolean checkIfDegreesMode() {
        return degreesMode;
    }

    public static void enableImpliedMultiplicationMode() {
        impliedMultiplicationMode = true;
        mXparserExp.enableImpliedMultiplicationMode();
    }

    public static void disableImpliedMultiplicationMode() {
        impliedMultiplicationMode = false;
        mXparserExp.disableImpliedMultiplicationMode();
    }

    public static boolean checkIfImpliedMultiplicationMode() {
        return impliedMultiplicationMode;
    }

    public static void enableUnicodeBuiltinKeyWordsMode() {
        unicodeKeyWordsEnabled = true;
        mXparserExp.enableUnicodeBuiltinKeyWordsMode();
    }

    public static void disableUnicodeBuiltinKeyWordsMode() {
        unicodeKeyWordsEnabled = false;
        mXparserExp.disableUnicodeBuiltinKeyWordsMode();
    }

    public static boolean checkIfUnicodeBuiltinKeyWordsMode() {
        return unicodeKeyWordsEnabled;
    }

    public static void enableAttemptToFixExpStrMode() {
        attemptToFixExpStrEnabled = true;
    }

    public static void disableAttemptToFixExpStrMode() {
        attemptToFixExpStrEnabled = false;
    }

    public static boolean checkIfAttemptToFixExpStrMode() {
        return attemptToFixExpStrEnabled;
    }

    public static void setToFractionInitSearchSize(long n) {
        NumberTheory.setToFractionInitSearchSize(n);
    }

    public static long getToFractionInitSearchSize() {
        return NumberTheory.getToFractionInitSearchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBuiltinTokens(String ... tokens) {
        if (tokens == null) {
            return;
        }
        List<String> list = tokensToRemove;
        synchronized (list) {
            for (String token : tokens) {
                if (token == null || token.length() <= 0 || tokensToRemove.contains(token)) continue;
                tokensToRemove.add(token);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unremoveBuiltinTokens(String ... tokens) {
        if (tokens == null) {
            return;
        }
        if (tokens.length == 0) {
            return;
        }
        if (tokensToRemove.size() == 0) {
            return;
        }
        List<String> list = tokensToRemove;
        synchronized (list) {
            for (String token : tokens) {
                if (token == null) continue;
                tokensToRemove.remove(token);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unremoveAllBuiltinTokens() {
        List<String> list = tokensToRemove;
        synchronized (list) {
            tokensToRemove.clear();
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getBuiltinTokensToRemove() {
        List<String> list = tokensToRemove;
        synchronized (list) {
            int tokensNum = tokensToRemove.size();
            String[] tokensToRemoveArray = new String[tokensNum];
            for (int i = 0; i < tokensNum; ++i) {
                tokensToRemoveArray[i] = tokensToRemove.get(i);
            }
            return tokensToRemoveArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyBuiltinToken(String currentToken, String newToken) {
        if (currentToken == null) {
            return;
        }
        if (currentToken.length() == 0) {
            return;
        }
        if (newToken == null) {
            return;
        }
        if (newToken.length() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            for (TokenModification tm : tokensToModify) {
                if (!tm.currentToken.equals(currentToken)) continue;
                return;
            }
            TokenModification tma = new TokenModification();
            tma.currentToken = currentToken;
            tma.newToken = newToken;
            tma.newTokenDescription = null;
            tokensToModify.add(tma);
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyBuiltinToken(String currentToken, String newToken, String newTokenDescription) {
        if (currentToken == null) {
            return;
        }
        if (currentToken.length() == 0) {
            return;
        }
        if (newToken == null) {
            return;
        }
        if (newToken.length() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            for (TokenModification tm : tokensToModify) {
                if (!tm.currentToken.equals(currentToken)) continue;
                return;
            }
            TokenModification tma = new TokenModification();
            tma.currentToken = currentToken;
            tma.newToken = newToken;
            tma.newTokenDescription = newTokenDescription;
            tokensToModify.add(tma);
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmodifyBuiltinTokens(String ... currentOrNewTokens) {
        if (currentOrNewTokens == null) {
            return;
        }
        if (currentOrNewTokens.length == 0) {
            return;
        }
        if (tokensToModify.size() == 0) {
            return;
        }
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            ArrayList<TokenModification> toRemove = new ArrayList<TokenModification>();
            for (String token : currentOrNewTokens) {
                if (token == null || token.length() <= 0) continue;
                for (TokenModification tm : tokensToModify) {
                    if (!token.equals(tm.currentToken) && !token.equals(tm.newToken)) continue;
                    toRemove.add(tm);
                }
            }
            for (TokenModification tm : toRemove) {
                tokensToModify.remove(tm);
            }
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmodifyAllBuiltinTokens() {
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            tokensToModify.clear();
            ++optionsChangesetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] getBuiltinTokensToModify() {
        List<TokenModification> list = tokensToModify;
        synchronized (list) {
            int tokensNum = tokensToModify.size();
            String[][] tokensToModifyArray = new String[tokensNum][3];
            for (int i = 0; i < tokensNum; ++i) {
                TokenModification tm = tokensToModify.get(i);
                tokensToModifyArray[i][0] = tm.currentToken;
                tokensToModifyArray[i][1] = tm.newToken;
                tokensToModifyArray[i][2] = tm.newTokenDescription;
            }
            return tokensToModifyArray;
        }
    }

    public static synchronized void setToOverrideBuiltinTokens() {
        overrideBuiltinTokens = true;
        ++optionsChangesetNumber;
    }

    public static synchronized void setNotToOverrideBuiltinTokens() {
        overrideBuiltinTokens = false;
        ++optionsChangesetNumber;
    }

    public static boolean checkIfsetToOverrideBuiltinTokens() {
        return overrideBuiltinTokens;
    }

    public static synchronized void setDefaultOptions() {
        mXparser.enableUlpRounding();
        mXparser.enableAlmostIntRounding();
        mXparser.setMaxAllowedRecursionDepth(200);
        mXparser.setNotToOverrideBuiltinTokens();
        mXparser.unmodifyAllBuiltinTokens();
        mXparser.setRadiansMode();
        mXparser.resetCancelCurrentCalculationFlag();
        mXparser.setDefaultEpsilon();
        mXparser.setEpsilonComparison();
        mXparser.setToFractionInitSearchSize(10000L);
        mXparser.enableImpliedMultiplicationMode();
        mXparser.enableUnicodeBuiltinKeyWordsMode();
        mXparser.enableAttemptToFixExpStrMode();
        ++optionsChangesetNumber;
    }

    public static String getTokenTypeDescription(int tokenTypeId) {
        String type = "";
        switch (tokenTypeId) {
            case 20: {
                type = "Parser Symbol";
                break;
            }
            case 0: {
                type = "Number";
                break;
            }
            case 1: {
                type = "Operator";
                break;
            }
            case 2: {
                type = "Boolean Operator";
                break;
            }
            case 3: {
                type = "Binary Relation";
                break;
            }
            case 4: {
                type = "Unary Function";
                break;
            }
            case 5: {
                type = "Binary Function";
                break;
            }
            case 6: {
                type = "3-args Function";
                break;
            }
            case 7: {
                type = "Variadic Function";
                break;
            }
            case 8: {
                type = "Calculus Operator";
                break;
            }
            case 10: {
                type = "Random Variable";
                break;
            }
            case 9: {
                type = "Constant Value";
                break;
            }
            case 101: {
                type = "User defined argument";
                break;
            }
            case 102: {
                type = "User defined recursive argument";
                break;
            }
            case 103: {
                type = "User defined function";
                break;
            }
            case 104: {
                type = "User defined constant";
                break;
            }
            case 12: {
                type = "Unit";
                break;
            }
            case 11: {
                type = "Bitwise Operator";
            }
        }
        return type;
    }

    public static String numberToHexString(int number) {
        return Integer.toHexString(number);
    }

    public static String numberToHexString(long number) {
        return Long.toHexString(number);
    }

    public static String numberToHexString(double number) {
        return mXparser.numberToHexString((long)number);
    }

    public static String hexString2AsciiString(String hexString) {
        String asciiString = "";
        for (int i = 0; i < hexString.length(); i += 2) {
            String hexByteStr = hexString.substring(i, i + 2);
            int hexByteInt = Integer.parseInt(hexByteStr, 16);
            asciiString = asciiString + (char)hexByteInt;
        }
        return asciiString;
    }

    public static String numberToAsciiString(int number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static String numberToAsciiString(long number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static String numberToAsciiString(double number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static double convOthBase2Decimal(String numberLiteral, int numeralSystemBase) {
        return NumberTheory.convOthBase2Decimal(numberLiteral, numeralSystemBase);
    }

    public static double convOthBase2Decimal(String numberLiteral) {
        return NumberTheory.convOthBase2Decimal(numberLiteral);
    }

    public static double convOthBase2Decimal(int numeralSystemBase, int ... digits) {
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static double convOthBase2Decimal(double numeralSystemBase, double ... digits) {
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static String convDecimal2OthBase(double decimalNumber, int numeralSystemBase) {
        return NumberTheory.convDecimal2OthBase(decimalNumber, numeralSystemBase);
    }

    public static String convDecimal2OthBase(double decimalNumber, int numeralSystemBase, int format) {
        return NumberTheory.convDecimal2OthBase(decimalNumber, numeralSystemBase, format);
    }

    public static double[] toFraction(double value) {
        return NumberTheory.toFraction(value);
    }

    public static double[] toMixedFraction(double value) {
        return NumberTheory.toMixedFraction(value);
    }

    public static String fractionToString(double[] fraction) {
        return NumberTheory.fractionToString(fraction);
    }

    public static String toFractionString(double value) {
        return NumberTheory.toFractionString(value);
    }

    public static String toMixedFractionString(double value) {
        return NumberTheory.toMixedFractionString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolePrintln(Object o) {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
                System.out.print(CONSOLE_PREFIX);
                CONSOLE_OUTPUT = CONSOLE_PREFIX;
            }
            System.out.println(o);
            ++CONSOLE_ROW_NUMBER;
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_OUTPUT + o + "\n" + CONSOLE_OUTPUT_PREFIX;
        }
    }

    public static void consolePrintln(String[] stringArray) {
        if (stringArray == null) {
            mXparser.consolePrintln("null");
            return;
        }
        for (String s : stringArray) {
            mXparser.consolePrintln(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolePrintln() {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
                System.out.print(CONSOLE_PREFIX);
                CONSOLE_OUTPUT = CONSOLE_PREFIX;
            }
            System.out.println();
            ++CONSOLE_ROW_NUMBER;
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_OUTPUT + "\n" + CONSOLE_OUTPUT_PREFIX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolePrint(Object o) {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
                System.out.print(CONSOLE_PREFIX);
                CONSOLE_OUTPUT = CONSOLE_PREFIX;
            }
            System.out.print(o);
            CONSOLE_OUTPUT = CONSOLE_OUTPUT + o;
        }
    }

    public static void consolePrintSettings(String prefix) {
        mXparser.consolePrintln(prefix + "checkIfCanonicalRounding = " + mXparser.checkIfCanonicalRounding());
        mXparser.consolePrintln(prefix + "checkIfAlmostIntRounding = " + mXparser.checkIfAlmostIntRounding());
        mXparser.consolePrintln(prefix + "checkIfUlpRounding = " + mXparser.checkIfUlpRounding());
        mXparser.consolePrintln(prefix + "checkIfRadiansMode = " + mXparser.checkIfRadiansMode());
        mXparser.consolePrintln(prefix + "checkIfDegreesMode = " + mXparser.checkIfDegreesMode());
        mXparser.consolePrintln(prefix + "checkIfExactMode = " + mXparser.checkIfExactMode());
        mXparser.consolePrintln(prefix + "checkIfEpsilonMode = " + mXparser.checkIfEpsilonMode());
        mXparser.consolePrintln(prefix + "getEpsilon = " + mXparser.getEpsilon());
        mXparser.consolePrintln(prefix + "getMaxAllowedRecursionDepth = " + mXparser.getMaxAllowedRecursionDepth());
        mXparser.consolePrintln(prefix + "getMaxNumInPrimesCache = " + mXparser.getMaxNumInPrimesCache());
        mXparser.consolePrintln(prefix + "getToFractionInitSearchSize = " + mXparser.getToFractionInitSearchSize());
        mXparser.consolePrintln(prefix + "checkIfsetToOverrideBuiltinTokens = " + mXparser.checkIfsetToOverrideBuiltinTokens());
        mXparser.consolePrintln(prefix + "Java version = " + System.getProperty("java.version"));
    }

    public static void consolePrintSettings() {
        mXparser.consolePrintSettings("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConsoleOutput() {
        String string = CONSOLE_OUTPUT;
        synchronized (string) {
            CONSOLE_OUTPUT = "";
            CONSOLE_ROW_NUMBER = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConsolePrefix() {
        String string = CONSOLE_PREFIX;
        synchronized (string) {
            CONSOLE_PREFIX = "[mXparser-v.5.0.2] ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConsoleOutputPrefix() {
        String string = CONSOLE_OUTPUT_PREFIX;
        synchronized (string) {
            CONSOLE_OUTPUT_PREFIX = "[mXparser-v.5.0.2] ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsolePrefix(String consolePrefix) {
        String string = CONSOLE_PREFIX;
        synchronized (string) {
            CONSOLE_PREFIX = consolePrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConsoleOutputPrefix(String consoleOutputPrefix) {
        String string = CONSOLE_OUTPUT_PREFIX;
        synchronized (string) {
            CONSOLE_OUTPUT_PREFIX = consoleOutputPrefix;
        }
    }

    public static String getConsoleOutput() {
        return CONSOLE_OUTPUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelp() {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelp(String word) {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getHelp(word);
        }
    }

    public static void consolePrintHelp() {
        System.out.println(mXparser.getHelp());
    }

    public static void consolePrintHelp(String word) {
        System.out.println(mXparser.getHelp(word));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyWord> getKeyWords() {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getKeyWords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyWord> getKeyWords(String query) {
        Expression expression = mXparserExp;
        synchronized (expression) {
            return mXparserExp.getKeyWords(query);
        }
    }

    public static boolean regexMatch(String str, String pattern) {
        return Pattern.matches(pattern, str);
    }

    public static void consolePrintTokens(List<Token> tokens) {
        Expression.showTokens(tokens);
    }

    public static void consolePrint(List<Token> tokens) {
        mXparser.consolePrintTokens(tokens);
    }

    public static void consolePrintln(List<Token> tokens) {
        mXparser.consolePrintTokens(tokens);
        mXparser.consolePrintln();
    }

    public static void consolePrintLicense() {
        mXparser.consolePrint("\n\n");
        mXparser.consolePrint(LICENSE);
        mXparser.consolePrintln();
    }

    public static String getLicense() {
        return LICENSE;
    }

    public static void wait(int n) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < (long)n) {
        }
    }

    public static void cancelCurrentCalculation() {
        cancelCurrentCalculationFlag = true;
    }

    public static void resetCancelCurrentCalculationFlag() {
        cancelCurrentCalculationFlag = false;
    }

    public static boolean isCurrentCalculationCancelled() {
        return cancelCurrentCalculationFlag;
    }

    static {
        CONSOLE_OUTPUT_PREFIX = CONSOLE_PREFIX = "[mXparser-v.5.0.2 bin JDK 8] ";
        CONSOLE_ROW_NUMBER = 1;
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
        ulpRounding = false;
        canonicalRounding = true;
        almostIntRounding = true;
        MAX_RECURSION_CALLS = 200;
        tokensToRemove = new ArrayList<String>();
        tokensToModify = new ArrayList<TokenModification>();
        degreesMode = false;
        overrideBuiltinTokens = false;
        impliedMultiplicationMode = true;
        unicodeKeyWordsEnabled = true;
        attemptToFixExpStrEnabled = true;
        optionsChangesetNumber = 0;
        cancelCurrentCalculationFlag = false;
        mXparserExp = new Expression(new PrimitiveElement[0]);
    }
}

