/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.List;
import org.mariuszgromada.math.mxparser.ArgumentExtension;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.HeadEqBody;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;

public class Argument
extends PrimitiveElement {
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    public static final double ARGUMENT_INITIAL_VALUE = Double.NaN;
    public static final int NOT_FOUND = -1;
    public static final int FREE_ARGUMENT = 1;
    public static final int DEPENDENT_ARGUMENT = 2;
    public static final int RECURSIVE_ARGUMENT = 3;
    public static final int TYPE_ID = 101;
    public static final String TYPE_DESC = "User defined argument";
    public static final int BODY_RUNTIME = 1;
    public static final int BODY_EXTENDED = 2;
    private int argumentBodyType;
    private ArgumentExtension argumentExtension;
    private String description;
    Expression argumentExpression;
    private String argumentName;
    int argumentType;
    double argumentValue;
    protected Argument n;

    public Argument(String argumentDefinitionString, PrimitiveElement ... elements) {
        super(101);
        if (mXparser.regexMatch(argumentDefinitionString, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = argumentDefinitionString;
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(elements);
        } else if (mXparser.regexMatch(argumentDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(argumentDefinitionString);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            Expression bodyExpr = new Expression(headEqBody.bodyStr, new PrimitiveElement[0]);
            double bodyValue = bodyExpr.calculate();
            if (bodyExpr.getSyntaxStatus() && bodyValue != Double.NaN) {
                this.argumentExpression = new Expression(new PrimitiveElement[0]);
                this.argumentValue = bodyValue;
                this.argumentType = 1;
            } else {
                this.argumentExpression = bodyExpr;
                this.addDefinitions(elements);
                this.argumentType = 2;
            }
        } else if (mXparser.regexMatch(argumentDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\(((\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*,(\\s)*)*(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(argumentDefinitionString);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            this.argumentExpression = new Expression(headEqBody.bodyStr, elements);
            this.argumentExpression.setDescription(headEqBody.headStr);
            this.argumentValue = Double.NaN;
            this.argumentType = 2;
            this.n = new Argument(headEqBody.headTokens.get((int)2).tokenStr, new PrimitiveElement[0]);
        } else {
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentDefinitionString + "] Invalid argument definition (patterns: 'x', 'x=5', 'x=5+3/2', 'x=2*y').");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String argumentDefinitionString, boolean forceDependent, PrimitiveElement ... elements) {
        super(101);
        if (mXparser.regexMatch(argumentDefinitionString, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = argumentDefinitionString;
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(elements);
        } else if (mXparser.regexMatch(argumentDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(argumentDefinitionString);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            Expression bodyExpr = new Expression(headEqBody.bodyStr, new PrimitiveElement[0]);
            if (forceDependent) {
                this.argumentExpression = bodyExpr;
                this.addDefinitions(elements);
                this.argumentType = 2;
            } else {
                double bodyValue = bodyExpr.calculate();
                if (bodyExpr.getSyntaxStatus() && bodyValue != Double.NaN) {
                    this.argumentExpression = new Expression(new PrimitiveElement[0]);
                    this.argumentValue = bodyValue;
                    this.argumentType = 1;
                } else {
                    this.argumentExpression = bodyExpr;
                    this.addDefinitions(elements);
                    this.argumentType = 2;
                }
            }
        } else if (mXparser.regexMatch(argumentDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\(((\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*,(\\s)*)*(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(argumentDefinitionString);
            this.argumentName = headEqBody.headTokens.get((int)0).tokenStr;
            this.argumentExpression = new Expression(headEqBody.bodyStr, elements);
            this.argumentExpression.setDescription(headEqBody.headStr);
            this.argumentValue = Double.NaN;
            this.argumentType = 2;
            this.n = new Argument(headEqBody.headTokens.get((int)2).tokenStr, new PrimitiveElement[0]);
        } else {
            this.argumentValue = Double.NaN;
            this.argumentType = 1;
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentDefinitionString + "] Invalid argument definition (patterns: 'x', 'x=5', 'x=5+3/2', 'x=2*y').");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String argumentName, double argumentValue) {
        super(101);
        this.argumentExpression = new Expression(new PrimitiveElement[0]);
        if (mXparser.regexMatch(argumentName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = new String(argumentName);
            this.argumentValue = argumentValue;
            this.argumentType = 1;
        } else {
            this.argumentValue = Double.NaN;
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentName + "] Invalid argument name, pattern not match: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String argumentName, ArgumentExtension argumentExtension) {
        super(101);
        this.argumentExpression = new Expression(new PrimitiveElement[0]);
        if (mXparser.regexMatch(argumentName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = new String(argumentName);
            this.argumentExtension = argumentExtension;
            this.argumentType = 1;
            this.argumentBodyType = 2;
        } else {
            this.argumentValue = Double.NaN;
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentName + "] Invalid argument name, pattern not match: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))");
            this.argumentBodyType = 1;
        }
        this.setSilentMode();
        this.description = "";
    }

    public Argument(String argumentName, String argumentExpressionString, PrimitiveElement ... elements) {
        super(101);
        if (mXparser.regexMatch(argumentName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = new String(argumentName);
            this.argumentValue = Double.NaN;
            this.argumentExpression = new Expression(argumentExpressionString, elements);
            this.argumentExpression.setDescription(argumentName);
            this.argumentType = 2;
        } else {
            this.argumentValue = Double.NaN;
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentName + "] Invalid argument name, pattern not match: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))");
        }
        this.argumentBodyType = 1;
        this.setSilentMode();
        this.description = "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setVerboseMode() {
        this.argumentExpression.setVerboseMode();
    }

    public void setSilentMode() {
        this.argumentExpression.setSilentMode();
    }

    public boolean getVerboseMode() {
        return this.argumentExpression.getVerboseMode();
    }

    public boolean getRecursiveMode() {
        return this.argumentExpression.getRecursiveMode();
    }

    public double getComputingTime() {
        return this.argumentExpression.getComputingTime();
    }

    public void setArgumentName(String argumentName) {
        if (mXparser.regexMatch(argumentName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.argumentName = argumentName;
            this.setExpressionModifiedFlags();
        } else if (this.argumentExpression != null) {
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentName + "] Invalid argument name, pattern not match: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))");
        }
    }

    public void setArgumentExpressionString(String argumentExpressionString) {
        this.argumentExpression.setExpressionString(argumentExpressionString);
        if (this.argumentType == 1) {
            this.argumentType = 2;
        }
        this.argumentBodyType = 1;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public String getArgumentExpressionString() {
        return this.argumentExpression.getExpressionString();
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentValue(double argumentValue) {
        if (this.argumentType == 2) {
            this.argumentType = 1;
            this.argumentExpression.setExpressionString("");
        }
        this.argumentBodyType = 1;
        this.argumentValue = argumentValue;
    }

    public int getArgumentBodyType() {
        return this.argumentBodyType;
    }

    public boolean checkSyntax() {
        if (this.argumentBodyType == 2) {
            return true;
        }
        if (this.argumentType == 1) {
            return true;
        }
        return this.argumentExpression.checkSyntax();
    }

    public String getErrorMessage() {
        return this.argumentExpression.getErrorMessage();
    }

    public double getArgumentValue() {
        if (this.argumentBodyType == 2) {
            return this.argumentExtension.getArgumentValue();
        }
        if (this.argumentType == 1) {
            return this.argumentValue;
        }
        return this.argumentExpression.calculate();
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        this.argumentExpression.addDefinitions(elements);
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        this.argumentExpression.removeDefinitions(elements);
    }

    public void addArguments(Argument ... arguments) {
        this.argumentExpression.addArguments(arguments);
    }

    public void defineArguments(String ... argumentsNames) {
        this.argumentExpression.defineArguments(argumentsNames);
    }

    public void defineArgument(String argumentName, double argumentValue) {
        this.argumentExpression.defineArgument(argumentName, argumentValue);
    }

    public int getArgumentIndex(String argumentName) {
        return this.argumentExpression.getArgumentIndex(argumentName);
    }

    public Argument getArgument(String argumentName) {
        return this.argumentExpression.getArgument(argumentName);
    }

    public Argument getArgument(int argumentIndex) {
        return this.argumentExpression.getArgument(argumentIndex);
    }

    public int getArgumentsNumber() {
        return this.argumentExpression.getArgumentsNumber();
    }

    public void removeArguments(String ... argumentsNames) {
        this.argumentExpression.removeArguments(argumentsNames);
    }

    public void removeArguments(Argument ... arguments) {
        this.argumentExpression.removeArguments(arguments);
    }

    public void removeAllArguments() {
        this.argumentExpression.removeAllArguments();
    }

    public void addConstants(Constant ... constants) {
        this.argumentExpression.addConstants(constants);
    }

    public void addConstants(List<Constant> constantsList) {
        this.argumentExpression.addConstants(constantsList);
    }

    public void defineConstant(String constantName, double constantValue) {
        this.argumentExpression.defineConstant(constantName, constantValue);
    }

    public int getConstantIndex(String constantName) {
        return this.argumentExpression.getConstantIndex(constantName);
    }

    public Constant getConstant(String constantName) {
        return this.argumentExpression.getConstant(constantName);
    }

    public Constant getConstant(int constantIndex) {
        return this.argumentExpression.getConstant(constantIndex);
    }

    public int getConstantsNumber() {
        return this.argumentExpression.getConstantsNumber();
    }

    public void removeConstants(String ... constantsNames) {
        this.argumentExpression.removeConstants(constantsNames);
    }

    public void removeConstants(Constant ... constants) {
        this.argumentExpression.removeConstants(constants);
    }

    public void removeAllConstants() {
        this.argumentExpression.removeAllConstants();
    }

    public void addFunctions(Function ... functions) {
        this.argumentExpression.addFunctions(functions);
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        this.argumentExpression.defineFunction(functionName, functionExpressionString, argumentsNames);
    }

    public int getFunctionIndex(String functionName) {
        return this.argumentExpression.getFunctionIndex(functionName);
    }

    public Function getFunction(String functionName) {
        return this.argumentExpression.getFunction(functionName);
    }

    public Function getFunction(int functionIndex) {
        return this.argumentExpression.getFunction(functionIndex);
    }

    public int getFunctionsNumber() {
        return this.argumentExpression.getFunctionsNumber();
    }

    public void removeFunctions(String ... functionsNames) {
        this.argumentExpression.removeFunctions(functionsNames);
    }

    public void removeFunctions(Function ... functions) {
        this.argumentExpression.removeFunctions(functions);
    }

    public void removeAllFunctions() {
        this.argumentExpression.removeAllFunctions();
    }

    void addRelatedExpression(Expression expression) {
        this.argumentExpression.addRelatedExpression(expression);
    }

    void removeRelatedExpression(Expression expression) {
        this.argumentExpression.removeRelatedExpression(expression);
    }

    void setExpressionModifiedFlags() {
        this.argumentExpression.setExpressionModifiedFlag();
    }

    public Argument clone() {
        Argument newArg = new Argument(this.argumentName, new PrimitiveElement[0]);
        newArg.argumentExpression = this.argumentExpression;
        newArg.argumentType = this.argumentType;
        newArg.argumentBodyType = this.argumentBodyType;
        newArg.argumentValue = this.argumentValue;
        newArg.description = this.description;
        newArg.n = this.n;
        newArg.argumentExtension = this.argumentExtension != null ? this.argumentExtension.clone() : null;
        return newArg;
    }
}

