/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.com.read.dao.CmdInformation;
import org.mariadb.jdbc.internal.com.read.dao.CmdInformationBatch;
import org.mariadb.jdbc.internal.com.read.dao.CmdInformationMultiple;
import org.mariadb.jdbc.internal.com.read.dao.CmdInformationSingle;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class Results {
    private MariaDbStatement statement;
    private int fetchSize;
    private boolean batch;
    private int expectedSize;
    private CmdInformation cmdInformation;
    private Deque<SelectResultSet> executionResults;
    private SelectResultSet resultSet;
    private SelectResultSet callableResultSet;
    private boolean binaryFormat;
    private int resultSetScrollType;
    private int resultSetConcurrency;
    private int autoGeneratedKeys;
    private int maxFieldSize;
    private int autoIncrement;
    private boolean rewritten;

    public Results() {
        this.statement = null;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.batch = false;
        this.expectedSize = 1;
        this.cmdInformation = null;
        this.binaryFormat = false;
        this.resultSetScrollType = 1003;
        this.resultSetConcurrency = 1007;
        this.autoIncrement = 1;
        this.autoGeneratedKeys = 2;
    }

    public Results(MariaDbStatement statement, int autoIncrement, int resultSetScrollType, int resultSetConcurrency) {
        this.statement = statement;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.batch = false;
        this.expectedSize = 1;
        this.cmdInformation = null;
        this.binaryFormat = false;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.autoIncrement = autoIncrement;
        this.autoGeneratedKeys = 2;
    }

    public Results(MariaDbStatement statement, int fetchSize, boolean batch, int expectedSize, boolean binaryFormat, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys, int autoIncrement) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.batch = batch;
        this.maxFieldSize = statement.getMaxFieldSize();
        this.expectedSize = expectedSize;
        this.cmdInformation = null;
        this.binaryFormat = binaryFormat;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.autoIncrement = autoIncrement;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public void addStats(long updateCount, long insertId, boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(insertId, updateCount, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addSuccessStat(updateCount, insertId);
    }

    public void addStatsError(boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -3L, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addErrorStat();
    }

    public int getCurrentStatNumber() {
        return this.cmdInformation == null ? 0 : this.cmdInformation.getCurrentStatNumber();
    }

    public void addResultSet(SelectResultSet resultSet, boolean moreResultAvailable) {
        if (resultSet.isCallableResult()) {
            this.callableResultSet = resultSet;
            return;
        }
        if (this.executionResults == null) {
            this.executionResults = new ArrayDeque<SelectResultSet>();
        }
        this.executionResults.add(resultSet);
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -1L, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addResultSetStat();
    }

    public CmdInformation getCmdInformation() {
        return this.cmdInformation;
    }

    protected void setCmdInformation(CmdInformation cmdInformation) {
        this.cmdInformation = cmdInformation;
    }

    public boolean commandEnd() {
        if (this.cmdInformation != null) {
            this.resultSet = this.executionResults != null && !this.cmdInformation.isCurrentUpdateCount() ? this.executionResults.poll() : null;
            this.cmdInformation.setRewrite(this.rewritten);
        } else {
            this.resultSet = null;
        }
        return this.cmdInformation != null;
    }

    public SelectResultSet getResultSet() {
        return this.resultSet;
    }

    public SelectResultSet getCallableResultSet() {
        return this.callableResultSet;
    }

    public void loadFully(boolean skip, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0) {
            this.fetchSize = 0;
            if (this.resultSet != null) {
                if (skip) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
            } else {
                SelectResultSet firstResult = this.executionResults.peekFirst();
                if (firstResult != null) {
                    if (skip) {
                        firstResult.close();
                    } else {
                        firstResult.fetchRemaining();
                    }
                }
            }
        }
        if (protocol.hasMoreResults()) {
            protocol.getResult(this);
        }
    }

    public void abort() throws SQLException {
        if (this.fetchSize != 0) {
            this.fetchSize = 0;
            if (this.resultSet != null) {
                this.resultSet.abort();
            } else {
                SelectResultSet firstResult = this.executionResults.peekFirst();
                if (firstResult != null) {
                    firstResult.abort();
                }
            }
        }
    }

    public boolean isFullyLoaded(Protocol protocol) {
        if (this.fetchSize == 0 || this.resultSet == null) {
            return true;
        }
        return this.resultSet.isFullyLoaded() && this.executionResults.isEmpty() && !protocol.hasMoreResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int current, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0 && this.resultSet != null) {
            protocol.getLock().lock();
            try {
                if (current == 1 && this.resultSet != null) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
                if (protocol.hasMoreResults()) {
                    protocol.getResult(this);
                }
            }
            catch (SQLException e) {
                ExceptionMapper.throwException(e, null, this.statement);
            }
            finally {
                protocol.getLock().unlock();
            }
        }
        if (this.cmdInformation.moreResults() && !this.batch) {
            if (current == 1 && this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.executionResults != null) {
                this.resultSet = this.executionResults.poll();
            }
            return this.resultSet != null;
        }
        if (current == 1 && this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = null;
        return false;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public MariaDbStatement getStatement() {
        return this.statement;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public boolean isBinaryFormat() {
        return this.binaryFormat;
    }

    public void removeFetchSize() {
        this.fetchSize = 0;
    }

    public int getResultSetScrollType() {
        return this.resultSetScrollType;
    }

    public ResultSet getGeneratedKeys(Protocol protocol) throws SQLException {
        if (this.autoGeneratedKeys != 1) {
            throw new SQLException("Cannot return generated keys : query was not set with Statement.RETURN_GENERATED_KEYS");
        }
        if (this.cmdInformation != null) {
            if (this.batch) {
                return this.cmdInformation.getBatchGeneratedKeys(protocol);
            }
            return this.cmdInformation.getGeneratedKeys(protocol);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    public void close() {
        this.statement = null;
        this.fetchSize = 0;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setAutoIncrement(int autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public boolean isRewritten() {
        return this.rewritten;
    }

    public void setRewritten(boolean rewritten) {
        this.rewritten = rewritten;
    }
}

