/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.dao;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;

public class ServerPrepareResult
implements PrepareResult {
    private int statementId;
    private final ColumnInformation[] columns;
    private final ColumnInformation[] parameters;
    private ColumnType[] parameterTypeHeader;
    private Protocol unProxiedProtocol;
    private final String sql;
    private volatile int shareCounter = 1;
    private volatile boolean isBeingDeallocate;
    private final AtomicBoolean inCache = new AtomicBoolean();

    public ServerPrepareResult(String sql, int statementId, ColumnInformation[] columns, ColumnInformation[] parameters, Protocol unProxiedProtocol) {
        this.sql = sql;
        this.statementId = statementId;
        this.columns = columns;
        this.parameters = parameters;
        this.unProxiedProtocol = unProxiedProtocol;
        this.parameterTypeHeader = new ColumnType[parameters.length];
    }

    public void resetParameterTypeHeader() {
        this.parameterTypeHeader = new ColumnType[this.parameters.length];
    }

    public void failover(int statementId, Protocol unProxiedProtocol) {
        this.statementId = statementId;
        this.unProxiedProtocol = unProxiedProtocol;
        this.parameterTypeHeader = new ColumnType[this.parameters.length];
        this.shareCounter = 1;
        this.isBeingDeallocate = false;
    }

    public void setAddToCache() {
        this.inCache.set(true);
    }

    public void setRemoveFromCache() {
        this.inCache.set(false);
    }

    public synchronized boolean incrementShareCounter() {
        if (this.isBeingDeallocate) {
            return false;
        }
        ++this.shareCounter;
        return true;
    }

    public synchronized void decrementShareCounter() {
        --this.shareCounter;
    }

    public synchronized boolean canBeDeallocate() {
        if (this.shareCounter > 0 || this.isBeingDeallocate) {
            return false;
        }
        if (!this.inCache.get()) {
            this.isBeingDeallocate = true;
            return true;
        }
        return false;
    }

    @Override
    public int getParamCount() {
        return this.parameters.length;
    }

    public synchronized int getShareCounter() {
        return this.shareCounter;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnInformation[] getColumns() {
        return this.columns;
    }

    public ColumnInformation[] getParameters() {
        return this.parameters;
    }

    public Protocol getUnProxiedProtocol() {
        return this.unProxiedProtocol;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public ColumnType[] getParameterTypeHeader() {
        return this.parameterTypeHeader;
    }
}

