/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.lang.reflect.Field;

public class Options {
    public String user;
    public String password;
    public boolean trustServerCertificate;
    public String serverSslCert;
    public String trustStore;
    public String trustStorePassword;
    public String keyStore;
    public String keyStorePassword;
    public String keyPassword;
    public String enabledSslProtocolSuites;
    public boolean useFractionalSeconds;
    public boolean pinGlobalTxToPhysicalConnection;
    public String socketFactory;
    public Integer connectTimeout;
    public String pipe;
    public String localSocket;
    public String sharedMemory;
    public boolean tcpNoDelay;
    public boolean tcpKeepAlive;
    public Integer tcpRcvBuf;
    public Integer tcpSndBuf;
    public boolean tcpAbortiveClose;
    public String localSocketAddress;
    public Integer socketTimeout;
    public boolean allowMultiQueries;
    public boolean rewriteBatchedStatements;
    public boolean useCompression;
    public boolean interactiveClient;
    public String passwordCharacterEncoding;
    public boolean useSsl;
    public String enabledSslCipherSuites;
    public String sessionVariables;
    public boolean tinyInt1isBit;
    public boolean yearIsDateType;
    public boolean createDatabaseIfNotExist;
    public String serverTimezone;
    public boolean nullCatalogMeansCurrent;
    public boolean dumpQueriesOnException;
    public boolean useOldAliasMetadataBehavior;
    public boolean allowLocalInfile;
    public boolean cachePrepStmts;
    public Integer prepStmtCacheSize;
    public Integer prepStmtCacheSqlLimit;
    public boolean useLegacyDatetimeCode;
    public boolean maximizeMysqlCompatibility;
    public boolean useServerPrepStmts;
    public boolean continueBatchOnError;
    public boolean jdbcCompliantTruncation;
    public boolean cacheCallableStmts;
    public Integer callableStmtCacheSize;
    public String connectionAttributes;
    public Boolean useBatchMultiSend;
    public int useBatchMultiSendNumber;
    public Boolean usePipelineAuth;
    public boolean killFetchStmtOnClose;
    public boolean enablePacketDebug;
    public boolean useBulkStmts;
    public boolean disableSslHostnameVerification;
    public boolean log;
    public boolean profileSql;
    public Integer maxQuerySizeToLog;
    public Long slowQueryThresholdNanos;
    public boolean assureReadOnly;
    public boolean autoReconnect;
    public boolean failOnReadOnly;
    public int retriesAllDown;
    public int validConnectionTimeout;
    public int loadBalanceBlacklistTimeout;
    public int failoverLoopRetries;

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Options {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            result.append("  ");
            try {
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Options options = (Options)obj;
        if (this.trustServerCertificate != options.trustServerCertificate) {
            return false;
        }
        if (this.useFractionalSeconds != options.useFractionalSeconds) {
            return false;
        }
        if (this.pinGlobalTxToPhysicalConnection != options.pinGlobalTxToPhysicalConnection) {
            return false;
        }
        if (this.tcpNoDelay != options.tcpNoDelay) {
            return false;
        }
        if (this.tcpKeepAlive != options.tcpKeepAlive) {
            return false;
        }
        if (this.tcpAbortiveClose != options.tcpAbortiveClose) {
            return false;
        }
        if (this.allowMultiQueries != options.allowMultiQueries) {
            return false;
        }
        if (this.rewriteBatchedStatements != options.rewriteBatchedStatements) {
            return false;
        }
        if (this.useCompression != options.useCompression) {
            return false;
        }
        if (this.interactiveClient != options.interactiveClient) {
            return false;
        }
        if (this.useSsl != options.useSsl) {
            return false;
        }
        if (this.enabledSslCipherSuites != options.enabledSslCipherSuites) {
            return false;
        }
        if (this.tinyInt1isBit != options.tinyInt1isBit) {
            return false;
        }
        if (this.yearIsDateType != options.yearIsDateType) {
            return false;
        }
        if (this.createDatabaseIfNotExist != options.createDatabaseIfNotExist) {
            return false;
        }
        if (this.nullCatalogMeansCurrent != options.nullCatalogMeansCurrent) {
            return false;
        }
        if (this.dumpQueriesOnException != options.dumpQueriesOnException) {
            return false;
        }
        if (this.useOldAliasMetadataBehavior != options.useOldAliasMetadataBehavior) {
            return false;
        }
        if (this.allowLocalInfile != options.allowLocalInfile) {
            return false;
        }
        if (this.cachePrepStmts != options.cachePrepStmts) {
            return false;
        }
        if (this.useLegacyDatetimeCode != options.useLegacyDatetimeCode) {
            return false;
        }
        if (this.maximizeMysqlCompatibility != options.maximizeMysqlCompatibility) {
            return false;
        }
        if (this.useServerPrepStmts != options.useServerPrepStmts) {
            return false;
        }
        if (this.assureReadOnly != options.assureReadOnly) {
            return false;
        }
        if (this.log != options.log) {
            return false;
        }
        if (this.profileSql != options.profileSql) {
            return false;
        }
        if (this.autoReconnect != options.autoReconnect) {
            return false;
        }
        if (this.failOnReadOnly != options.failOnReadOnly) {
            return false;
        }
        if (this.retriesAllDown != options.retriesAllDown) {
            return false;
        }
        if (this.validConnectionTimeout != options.validConnectionTimeout) {
            return false;
        }
        if (this.loadBalanceBlacklistTimeout != options.loadBalanceBlacklistTimeout) {
            return false;
        }
        if (this.failoverLoopRetries != options.failoverLoopRetries) {
            return false;
        }
        if (this.user != null ? !this.user.equals(options.user) : options.user != null) {
            return false;
        }
        if (this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.equals(options.passwordCharacterEncoding) || options.passwordCharacterEncoding != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(options.password) : options.password != null) {
            return false;
        }
        if (this.serverSslCert != null ? !this.serverSslCert.equals(options.serverSslCert) : options.serverSslCert != null) {
            return false;
        }
        if (this.enabledSslProtocolSuites != null ? !this.enabledSslProtocolSuites.equals(options.enabledSslProtocolSuites) : options.enabledSslProtocolSuites != null) {
            return false;
        }
        if (this.socketFactory != null ? !this.socketFactory.equals(options.socketFactory) : options.socketFactory != null) {
            return false;
        }
        if (this.connectTimeout != null ? !this.connectTimeout.equals(options.connectTimeout) : options.connectTimeout != null) {
            return false;
        }
        if (this.pipe != null ? !this.pipe.equals(options.pipe) : options.pipe != null) {
            return false;
        }
        if (this.localSocket != null ? !this.localSocket.equals(options.localSocket) : options.localSocket != null) {
            return false;
        }
        if (this.sharedMemory != null ? !this.sharedMemory.equals(options.sharedMemory) : options.sharedMemory != null) {
            return false;
        }
        if (this.tcpRcvBuf != null ? !this.tcpRcvBuf.equals(options.tcpRcvBuf) : options.tcpRcvBuf != null) {
            return false;
        }
        if (this.tcpSndBuf != null ? !this.tcpSndBuf.equals(options.tcpSndBuf) : options.tcpSndBuf != null) {
            return false;
        }
        if (this.localSocketAddress != null ? !this.localSocketAddress.equals(options.localSocketAddress) : options.localSocketAddress != null) {
            return false;
        }
        if (this.socketTimeout != null ? !this.socketTimeout.equals(options.socketTimeout) : options.socketTimeout != null) {
            return false;
        }
        if (this.sessionVariables != null ? !this.sessionVariables.equals(options.sessionVariables) : options.sessionVariables != null) {
            return false;
        }
        if (this.serverTimezone != null ? !this.serverTimezone.equals(options.serverTimezone) : options.serverTimezone != null) {
            return false;
        }
        if (this.prepStmtCacheSize != null ? !this.prepStmtCacheSize.equals(options.prepStmtCacheSize) : options.prepStmtCacheSize != null) {
            return false;
        }
        if (this.continueBatchOnError != options.continueBatchOnError) {
            return false;
        }
        if (this.jdbcCompliantTruncation != options.jdbcCompliantTruncation) {
            return false;
        }
        if (this.cacheCallableStmts != options.cacheCallableStmts) {
            return false;
        }
        if (this.callableStmtCacheSize != null ? !this.callableStmtCacheSize.equals(options.callableStmtCacheSize) : options.callableStmtCacheSize != null) {
            return false;
        }
        if (this.maxQuerySizeToLog != null ? !this.maxQuerySizeToLog.equals(options.maxQuerySizeToLog) : options.maxQuerySizeToLog != null) {
            return false;
        }
        if (this.connectionAttributes != null ? !this.connectionAttributes.equals(options.connectionAttributes) : options.connectionAttributes != null) {
            return false;
        }
        if (this.slowQueryThresholdNanos != null ? !this.slowQueryThresholdNanos.equals(options.slowQueryThresholdNanos) : options.slowQueryThresholdNanos != null) {
            return false;
        }
        if (this.useBatchMultiSend != options.useBatchMultiSend) {
            return false;
        }
        if (this.useBatchMultiSendNumber != options.useBatchMultiSendNumber) {
            return false;
        }
        if (this.usePipelineAuth != options.usePipelineAuth) {
            return false;
        }
        if (this.useBulkStmts != options.useBulkStmts) {
            return false;
        }
        if (this.enablePacketDebug != options.enablePacketDebug) {
            return false;
        }
        if (this.killFetchStmtOnClose != options.killFetchStmtOnClose) {
            return false;
        }
        if (this.disableSslHostnameVerification != options.disableSslHostnameVerification) {
            return false;
        }
        return !(this.prepStmtCacheSqlLimit == null ? options.prepStmtCacheSqlLimit != null : !this.prepStmtCacheSqlLimit.equals(options.prepStmtCacheSqlLimit));
    }
}

