/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.buffer;

import java.io.IOException;
import java.nio.charset.Charset;

public class Buffer {
    public byte[] buf;
    public int position;
    public int limit;

    public Buffer(byte[] buf, int limit) {
        this.buf = buf;
        this.limit = limit;
    }

    public Buffer(byte[] buf) {
        this.buf = buf;
        this.limit = this.buf.length;
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public String readString(Charset charset) {
        byte ch;
        int cnt = 0;
        byte[] byteArrBuff = new byte[this.remaining()];
        while (this.remaining() > 0 && (ch = this.buf[this.position++]) != 0) {
            byteArrBuff[cnt++] = ch;
        }
        return new String(byteArrBuff, 0, cnt, charset);
    }

    public short readShort() {
        return (short)((this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8));
    }

    public int read24bitword() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16);
    }

    public int readInt() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16) + ((this.buf[this.position++] & 0xFF) << 24);
    }

    public long readLong() {
        return (long)(this.buf[this.position++] & 0xFF) + ((long)(this.buf[this.position++] & 0xFF) << 8) + ((long)(this.buf[this.position++] & 0xFF) << 16) + ((long)(this.buf[this.position++] & 0xFF) << 24) + ((long)(this.buf[this.position++] & 0xFF) << 32) + ((long)(this.buf[this.position++] & 0xFF) << 40) + ((long)(this.buf[this.position++] & 0xFF) << 48) + ((long)(this.buf[this.position++] & 0xFF) << 56);
    }

    public byte readByte() {
        return this.buf[this.position++];
    }

    public byte[] readRawBytes(int numberOfBytes) {
        byte[] tmpArr = new byte[numberOfBytes];
        for (int i = 0; i < numberOfBytes; ++i) {
            tmpArr[i] = this.buf[this.position++];
        }
        return tmpArr;
    }

    public void skipByte() {
        ++this.position;
    }

    public void skipBytes(int bytesToSkip) {
        this.position += bytesToSkip;
    }

    public void skipLengthEncodedBytes() {
        int type = this.buf[this.position++] & 0xFF;
        switch (type) {
            case 251: {
                break;
            }
            case 252: {
                this.position += 2 + ((this.buf[this.position] & 0xFF) + ((this.buf[this.position + 1] & 0xFF) << 8));
                break;
            }
            case 253: {
                this.position += 3 + (this.buf[this.position] & 0xFF) + ((this.buf[this.position + 1] & 0xFF) << 8) + ((this.buf[this.position + 2] & 0xFF) << 16);
                break;
            }
            case 254: {
                this.position = (int)((long)this.position + (8L + ((long)(this.buf[this.position] & 0xFF) + ((long)(this.buf[this.position + 1] & 0xFF) << 8) + ((long)(this.buf[this.position + 2] & 0xFF) << 16) + ((long)(this.buf[this.position + 3] & 0xFF) << 24) + ((long)(this.buf[this.position + 4] & 0xFF) << 32) + ((long)(this.buf[this.position + 5] & 0xFF) << 40) + ((long)(this.buf[this.position + 6] & 0xFF) << 48) + ((long)(this.buf[this.position + 7] & 0xFF) << 56))));
                break;
            }
            default: {
                this.position += type;
            }
        }
    }

    public long getLengthEncodedBinary() {
        int type = this.buf[this.position++] & 0xFF;
        switch (type) {
            case 251: {
                return -1L;
            }
            case 252: {
                return this.readShort();
            }
            case 253: {
                return this.read24bitword();
            }
            case 254: {
                return this.readLong();
            }
        }
        return type;
    }

    public byte[] getLengthEncodedBytes() throws IOException {
        if (this.remaining() <= 0) {
            return new byte[0];
        }
        long length = this.getLengthEncodedBinary();
        return this.getLengthEncodedBytesWithLength(length);
    }

    public byte[] getLengthEncodedBytesWithLength(long length) {
        if (length < 0L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)length];
        int i = 0;
        while ((long)i < length) {
            tmpBuf[i] = this.buf[this.position++];
            ++i;
        }
        return tmpBuf;
    }

    public byte getByteAt(int position) {
        return this.buf[position];
    }

    public void appendPacket(Buffer otherBuffer) {
        byte[] newBuffer = new byte[this.limit - this.position + otherBuffer.limit];
        System.arraycopy(this.buf, this.position, newBuffer, 0, this.remaining());
        System.arraycopy(otherBuffer.buf, 0, newBuffer, this.limit - this.position, otherBuffer.limit);
        this.buf = newBuffer;
        this.limit = this.limit - this.position + otherBuffer.limit;
        this.position = 0;
    }

    public long getSilentLengthEncodedBinary() {
        if (this.remaining() <= 0) {
            return 0L;
        }
        int type = this.buf[this.position] & 0xFF;
        switch (type) {
            case 251: {
                return -1L;
            }
            case 252: {
                return 0xFFFF & (this.buf[this.position + 1] & 0xFF) + ((this.buf[this.position + 2] & 0xFF) << 8);
            }
            case 253: {
                return (this.buf[this.position + 1] & 0xFF) + ((this.buf[this.position + 2] & 0xFF) << 8) + ((this.buf[this.position + 3] & 0xFF) << 16);
            }
            case 254: {
                return (this.buf[this.position + 1] & 0xFF) + ((this.buf[this.position + 2] & 0xFF) << 8) + ((this.buf[this.position + 3] & 0xFF) << 16) + ((this.buf[this.position + 4] & 0xFF) << 24);
            }
        }
        return type;
    }
}

