/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.queryresults.MariaDbValueObject;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class BinaryRowPacket
implements RowPacket {
    private final ColumnInformation[] columnInformation;
    private final Options options;
    private final int columnInformationLength;

    public BinaryRowPacket(ColumnInformation[] columnInformation, Options options, int columnInformationLength) {
        this.columnInformation = columnInformation;
        this.options = options;
        this.columnInformationLength = columnInformationLength;
    }

    public void appendPacketIfNeeded(Buffer buffer, ReadPacketFetcher packetFetcher) throws IOException {
        long encLength = buffer.getSilentLengthEncodedBinary();
        while (encLength > (long)buffer.remaining()) {
            buffer.appendPacket(packetFetcher.getPacket());
            encLength = buffer.getSilentLengthEncodedBinary();
        }
    }

    public void appendPacketIfNeeded(Buffer buffer, ReadPacketFetcher packetFetcher, long encLength) throws IOException {
        while (encLength > (long)buffer.remaining()) {
            buffer.appendPacket(packetFetcher.getPacket());
            encLength = buffer.getSilentLengthEncodedBinary();
        }
    }

    @Override
    public ValueObject[] getRow(ReadPacketFetcher packetFetcher, Buffer buffer) throws IOException {
        ValueObject[] valueObjects = new ValueObject[this.columnInformationLength];
        buffer.skipByte();
        int nullCount = (this.columnInformationLength + 9) / 8;
        byte[] nullBitsBuffer = buffer.readRawBytes(nullCount);
        block10: for (int i = 0; i < this.columnInformationLength; ++i) {
            if ((nullBitsBuffer[(i + 2) / 8] & 1 << (i + 2) % 8) > 0) {
                valueObjects[i] = new MariaDbValueObject(null, this.columnInformation[i], true, this.options);
                continue;
            }
            switch (this.columnInformation[i].getType()) {
                case VARCHAR: 
                case BIT: 
                case ENUM: 
                case SET: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case VARSTRING: 
                case STRING: 
                case GEOMETRY: 
                case OLDDECIMAL: 
                case DECIMAL: {
                    this.appendPacketIfNeeded(buffer, packetFetcher);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytes(), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case BIGINT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 8L);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytesWithLength(8L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 4L);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytesWithLength(4L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case SMALLINT: 
                case YEAR: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 2L);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytesWithLength(2L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case TINYINT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 1L);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytesWithLength(1L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case DOUBLE: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 8L);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytesWithLength(8L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case FLOAT: {
                    this.appendPacketIfNeeded(buffer, packetFetcher, 4L);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytesWithLength(4L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case TIME: 
                case DATE: 
                case DATETIME: 
                case TIMESTAMP: {
                    this.appendPacketIfNeeded(buffer, packetFetcher);
                    valueObjects[i] = new MariaDbValueObject(buffer.getLengthEncodedBytes(), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                default: {
                    this.appendPacketIfNeeded(buffer, packetFetcher);
                    valueObjects[i] = new MariaDbValueObject(null, this.columnInformation[i], true, this.options);
                }
            }
        }
        return valueObjects;
    }
}

