/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class ReadPacketFetcher {
    public static final int AVOID_CREATE_BUFFER_LENGTH = 4096;
    private final InputStream inputStream;
    private byte[] headerBuffer = new byte[4];
    private byte[] reusableBuffer = new byte[4096];
    private int lastPacketSeq;

    public ReadPacketFetcher(InputStream is) {
        this.inputStream = is;
    }

    public Buffer getPacket() throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.headerBuffer, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (4 - remaining) + " bytes from " + 4);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        this.lastPacketSeq = this.headerBuffer[3];
        int length = (this.headerBuffer[0] & 0xFF) + ((this.headerBuffer[1] & 0xFF) << 8) + ((this.headerBuffer[2] & 0xFF) << 16);
        byte[] rawBytes = new byte[length];
        remaining = length;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length);
            }
            off += count;
        } while ((remaining -= count) > 0);
        return new Buffer(rawBytes, length);
    }

    public Buffer getReusableBuffer() throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.headerBuffer, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (4 - remaining) + " bytes from " + 4);
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        this.lastPacketSeq = this.headerBuffer[3];
        int length = (this.headerBuffer[0] & 0xFF) + ((this.headerBuffer[1] & 0xFF) << 8) + ((this.headerBuffer[2] & 0xFF) << 16);
        byte[] rawBytes = length < 4096 ? this.reusableBuffer : new byte[length];
        remaining = length;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length);
            }
            off += count;
        } while ((remaining -= count) > 0);
        return new Buffer(rawBytes, length);
    }

    public int getLastPacketSeq() {
        return this.lastPacketSeq;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

