/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLStatement;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.query.parameters.BigDecimalParameter;
import org.mariadb.jdbc.internal.common.query.parameters.BigIntParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ByteArrayParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ByteParameter;
import org.mariadb.jdbc.internal.common.query.parameters.DateParameter;
import org.mariadb.jdbc.internal.common.query.parameters.DoubleParameter;
import org.mariadb.jdbc.internal.common.query.parameters.FloatParameter;
import org.mariadb.jdbc.internal.common.query.parameters.IntParameter;
import org.mariadb.jdbc.internal.common.query.parameters.LongParameter;
import org.mariadb.jdbc.internal.common.query.parameters.NullParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ReaderParameter;
import org.mariadb.jdbc.internal.common.query.parameters.SerializableParameter;
import org.mariadb.jdbc.internal.common.query.parameters.ShortParameter;
import org.mariadb.jdbc.internal.common.query.parameters.StreamParameter;
import org.mariadb.jdbc.internal.common.query.parameters.StringParameter;
import org.mariadb.jdbc.internal.common.query.parameters.TimeParameter;
import org.mariadb.jdbc.internal.common.query.parameters.TimestampParameter;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public abstract class AbstractMySQLPrepareStatement
extends MySQLStatement
implements PreparedStatement {
    private boolean useFractionalSeconds;

    public AbstractMySQLPrepareStatement(MySQLConnection connection) {
        super(connection);
    }

    protected abstract boolean isNoBackslashEscapes();

    protected abstract boolean useFractionalSeconds();

    protected abstract Calendar cal();

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("REF not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x.getBinaryStream(), this.isNoBackslashEscapes()));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(x.getCharacterStream(), x.length(), this.isNoBackslashEscapes()));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Arrays not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        this.setParameter(parameterIndex, new DateParameter(date, cal, this.protocol.getOptions()));
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        if (time == null) {
            this.setNull(parameterIndex, MySQLType.TIME);
            return;
        }
        this.setParameter(parameterIndex, new TimeParameter(time, cal, this.useFractionalSeconds(), this.protocol.getOptions()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, MySQLType.DATETIME);
            return;
        }
        TimestampParameter t = new TimestampParameter(timestamp, cal, this.useFractionalSeconds(), this.protocol.getOptions());
        this.setParameter(parameterIndex, t);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    public void setNull(int parameterIndex, MySQLType mysqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter(mysqlType));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    protected abstract void setParameter(int var1, ParameterHolder var2) throws SQLException;

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, new StringParameter(x.toString(), this.isNoBackslashEscapes()));
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NStrings not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NCharstreams not supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("SQlXML not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, this.isNoBackslashEscapes()));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, this.isNoBackslashEscapes()));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, this.isNoBackslashEscapes()));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(value ? (byte)1 : 0));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, new ShortParameter(x));
    }

    @Override
    public void setString(int column, String s) throws SQLException {
        if (s == null) {
            this.setNull(column, MySQLType.VARCHAR);
            return;
        }
        this.setParameter(column, new StringParameter(s, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ByteArrayParameter(x, this.isNoBackslashEscapes()));
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setDate(parameterIndex, date, this.cal());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.cal());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.setTimestamp(parameterIndex, timestamp, this.cal());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.isNoBackslashEscapes()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw SQLExceptionMapper.getFeatureNotSupportedException("Type not supported");
            }
        }
        if (x == null) {
            this.setNull(parameterIndex, 4);
            return;
        } else if (x instanceof String) {
            if (targetSqlType == 2004) {
                throw SQLExceptionMapper.getSQLException("Cannot convert a String to a Blob");
            }
            String s = (String)x;
            try {
                switch (targetSqlType) {
                    case -7: {
                        this.setBoolean(parameterIndex, Boolean.valueOf(s));
                        return;
                    }
                    case -6: {
                        this.setByte(parameterIndex, Byte.parseByte(s));
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, Short.parseShort(s));
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, Integer.parseInt(s));
                        return;
                    }
                    case 8: {
                        this.setDouble(parameterIndex, Double.valueOf(s));
                        return;
                    }
                    case 6: 
                    case 7: {
                        this.setFloat(parameterIndex, Float.valueOf(s).floatValue());
                        return;
                    }
                    case -5: {
                        this.setBigInt(parameterIndex, new BigInteger(s));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.setBigDecimal(parameterIndex, new BigDecimal(s));
                        return;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, s);
                        return;
                    }
                    case 93: {
                        if (x != null && ((String)x).startsWith("0000-00-00")) {
                            this.setTimestamp(parameterIndex, null);
                            return;
                        }
                        this.setTimestamp(parameterIndex, Timestamp.valueOf((String)x));
                        return;
                    }
                    case 92: {
                        this.setTime(parameterIndex, Time.valueOf((String)x));
                        return;
                    }
                    default: {
                        throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw SQLExceptionMapper.getSQLException("Could not convert [" + s + "] to " + targetSqlType, e);
            }
        } else if (x instanceof Number) {
            this.testNumbers(targetSqlType);
            Number bd = (Number)x;
            switch (targetSqlType) {
                case -6: {
                    this.setByte(parameterIndex, bd.byteValue());
                    return;
                }
                case 5: {
                    this.setShort(parameterIndex, bd.shortValue());
                    return;
                }
                case 4: {
                    this.setInt(parameterIndex, bd.intValue());
                    return;
                }
                case -5: {
                    this.setBigInt(parameterIndex, (BigInteger)bd);
                    return;
                }
                case 8: {
                    this.setDouble(parameterIndex, bd.doubleValue());
                    return;
                }
                case 6: 
                case 7: {
                    this.setFloat(parameterIndex, bd.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (x instanceof BigDecimal) {
                        this.setBigDecimal(parameterIndex, (BigDecimal)x);
                        return;
                    }
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case -7: {
                    this.setBoolean(parameterIndex, bd.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.setString(parameterIndex, bd.toString());
                    return;
                }
                default: {
                    throw SQLExceptionMapper.getSQLException("Could not convert [" + bd + "] to " + targetSqlType);
                }
            }
        } else if (x instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4) throw SQLExceptionMapper.getSQLException("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            this.setBytes(parameterIndex, (byte[])x);
            return;
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        } else if (x instanceof java.util.Date) {
            long t = ((java.util.Date)x).getTime();
            if (targetSqlType == 91) {
                this.setDate(parameterIndex, new Date(t));
                return;
            } else if (targetSqlType == 92) {
                this.setTime(parameterIndex, new Time(t));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.setTimestamp(parameterIndex, new Timestamp(t));
            }
            return;
        } else if (x instanceof Boolean) {
            this.testNumbers(targetSqlType);
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        } else {
            if (!(x instanceof BigInteger)) throw SQLExceptionMapper.getSQLException("Could not set parameter in setObject, could not convert: " + x.getClass() + " to " + targetSqlType);
            this.setBigInt(parameterIndex, (BigInteger)x);
        }
    }

    private void testNumbers(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                throw SQLExceptionMapper.getSQLException("Cannot convert to " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 4);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof BigInteger) {
            this.setBigInt(parameterIndex, (BigInteger)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else {
            try {
                this.setParameter(parameterIndex, new SerializableParameter(x, this.isNoBackslashEscapes()));
            }
            catch (IOException e) {
                throw SQLExceptionMapper.getSQLException("Could not set serializable parameter in setObject: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void setInt(int column, int i) throws SQLException {
        this.setParameter(column, new IntParameter(i));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, new LongParameter(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, new FloatParameter(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.DECIMAL);
            return;
        }
        this.setParameter(parameterIndex, new BigDecimalParameter(x));
    }

    private void setBigInt(int parameterIndex, BigInteger x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MySQLType.VARSTRING);
            return;
        }
        this.setParameter(parameterIndex, new BigIntParameter(x));
    }
}

