/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.util.Calendar;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class DateParameter
extends NotLongDataParameterHolder {
    Date date;
    Calendar calendar;
    Options options;

    public DateParameter(Date date, Calendar cal, Options options) {
        this.date = date;
        this.calendar = cal;
        this.options = options;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.options.useLegacyDatetimeCode || this.options.maximizeMysqlCompatibility) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(this.date.getTime());
        ParameterWriter.writeDate(os, this.calendar);
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        if (this.options.useLegacyDatetimeCode || this.options.maximizeMysqlCompatibility) {
            // empty if block
        }
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(this.date.getTime());
        writeBuffer.writeDateLength(this.calendar);
    }

    @Override
    public MySQLType getMySQLType() {
        return MySQLType.DATE;
    }
}

