/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class ByteArrayParameter
extends NotLongDataParameterHolder {
    byte[] bytes;
    boolean noBackslashEscapes;

    public ByteArrayParameter(byte[] bytes, boolean noBackslashEscapes) {
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.write(os, this.bytes, this.noBackslashEscapes);
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeByteArrayLength(this.bytes);
    }

    @Override
    public MySQLType getMySQLType() {
        return MySQLType.VARSTRING;
    }

    @Override
    public String toString() {
        return "<bytearray> " + this.bytes.toString();
    }
}

