/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util.accessor;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;

public class ElementAccessor
implements Accessor {
    private final Element element;
    private final String name;
    private final AccessorType accessorType;
    private final TypeMirror accessedType;

    public ElementAccessor(VariableElement variableElement, TypeMirror accessedType) {
        this((Element)variableElement, accessedType, AccessorType.FIELD);
    }

    public ElementAccessor(Element element, TypeMirror accessedType, String name) {
        this.element = element;
        this.name = name;
        this.accessedType = accessedType;
        this.accessorType = AccessorType.PARAMETER;
    }

    public ElementAccessor(Element element, TypeMirror accessedType, AccessorType accessorType) {
        this.element = element;
        this.accessedType = accessedType;
        this.accessorType = accessorType;
        this.name = null;
    }

    @Override
    public TypeMirror getAccessedType() {
        return this.accessedType != null ? this.accessedType : this.element.asType();
    }

    @Override
    public String getSimpleName() {
        return this.name != null ? this.name : this.element.getSimpleName().toString();
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public AccessorType getAccessorType() {
        return this.accessorType;
    }
}

