/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Fields;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.internal.util.accessor.ElementAccessor;
import org.mapstruct.ap.internal.util.accessor.ReadAccessor;

public class Filters {
    private static final Method RECORD_COMPONENTS_METHOD;
    private final AccessorNamingUtils accessorNaming;
    private final TypeUtils typeUtils;
    private final TypeMirror typeMirror;

    public Filters(AccessorNamingUtils accessorNaming, TypeUtils typeUtils, TypeMirror typeMirror) {
        this.accessorNaming = accessorNaming;
        this.typeUtils = typeUtils;
        this.typeMirror = typeMirror;
    }

    public List<ReadAccessor> getterMethodsIn(List<ExecutableElement> elements) {
        return elements.stream().filter(this.accessorNaming::isGetterMethod).map(method -> ReadAccessor.fromGetter(method, this.getReturnType((ExecutableElement)method))).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<Element> recordComponentsIn(TypeElement typeElement) {
        if (RECORD_COMPONENTS_METHOD == null) {
            return java.util.Collections.emptyList();
        }
        try {
            return (List)RECORD_COMPONENTS_METHOD.invoke((Object)typeElement, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return java.util.Collections.emptyList();
        }
    }

    public Map<String, ReadAccessor> recordAccessorsIn(Collection<Element> recordComponents) {
        if (recordComponents.isEmpty()) {
            return java.util.Collections.emptyMap();
        }
        LinkedHashMap<String, ReadAccessor> recordAccessors = new LinkedHashMap<String, ReadAccessor>();
        for (Element recordComponent : recordComponents) {
            recordAccessors.put(recordComponent.getSimpleName().toString(), ReadAccessor.fromRecordComponent(recordComponent, this.typeUtils.asMemberOf((DeclaredType)this.typeMirror, recordComponent)));
        }
        return recordAccessors;
    }

    private TypeMirror getReturnType(ExecutableElement executableElement) {
        return this.getWithinContext(executableElement).getReturnType();
    }

    public <T> List<T> fieldsIn(List<VariableElement> accessors, BiFunction<VariableElement, TypeMirror, T> creator) {
        return accessors.stream().filter(Fields::isFieldAccessor).map(variableElement -> creator.apply((VariableElement)variableElement, this.getWithinContext((VariableElement)variableElement))).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<ExecutableElement> presenceCheckMethodsIn(List<ExecutableElement> elements) {
        return elements.stream().filter(this.accessorNaming::isPresenceCheckMethod).collect(Collectors.toCollection(LinkedList::new));
    }

    public List<Accessor> setterMethodsIn(List<ExecutableElement> elements) {
        return elements.stream().filter(this.accessorNaming::isSetterMethod).map(method -> new ElementAccessor((Element)method, this.getFirstParameter((ExecutableElement)method), AccessorType.SETTER)).collect(Collectors.toCollection(LinkedList::new));
    }

    private TypeMirror getFirstParameter(ExecutableElement executableElement) {
        return Collections.first(this.getWithinContext(executableElement).getParameterTypes());
    }

    private ExecutableType getWithinContext(ExecutableElement executableElement) {
        return (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)this.typeMirror, executableElement);
    }

    private TypeMirror getWithinContext(VariableElement variableElement) {
        return this.typeUtils.asMemberOf((DeclaredType)this.typeMirror, variableElement);
    }

    public List<Accessor> adderMethodsIn(List<ExecutableElement> elements) {
        return elements.stream().filter(this.accessorNaming::isAdderMethod).map(method -> new ElementAccessor((Element)method, this.getFirstParameter((ExecutableElement)method), AccessorType.ADDER)).collect(Collectors.toCollection(LinkedList::new));
    }

    static {
        Method recordComponentsMethod;
        try {
            recordComponentsMethod = TypeElement.class.getMethod("getRecordComponents", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            recordComponentsMethod = null;
        }
        RECORD_COMPONENTS_METHOD = recordComponentsMethod;
    }
}

