/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.option;

import java.util.Locale;
import java.util.Map;
import org.mapstruct.ap.internal.gem.NullValueMappingStrategyGem;
import org.mapstruct.ap.internal.gem.ReportingPolicyGem;
import org.mapstruct.ap.internal.option.MappingOption;

public class Options {
    private final Map<String, String> options;

    public Options(Map<String, String> options) {
        this.options = options;
    }

    public boolean isSuppressGeneratorTimestamp() {
        return this.parseBoolean(MappingOption.SUPPRESS_GENERATOR_TIMESTAMP);
    }

    public boolean isSuppressGeneratorVersionComment() {
        return this.parseBoolean(MappingOption.SUPPRESS_GENERATOR_VERSION_INFO_COMMENT);
    }

    public ReportingPolicyGem getUnmappedTargetPolicy() {
        return this.parseEnum(MappingOption.UNMAPPED_TARGET_POLICY, ReportingPolicyGem.class);
    }

    public ReportingPolicyGem getUnmappedSourcePolicy() {
        return this.parseEnum(MappingOption.UNMAPPED_SOURCE_POLICY, ReportingPolicyGem.class);
    }

    public String getDefaultComponentModel() {
        return this.options.get(MappingOption.DEFAULT_COMPONENT_MODEL.getOptionName());
    }

    public String getDefaultInjectionStrategy() {
        return this.options.get(MappingOption.DEFAULT_INJECTION_STRATEGY.getOptionName());
    }

    public boolean isAlwaysGenerateSpi() {
        return this.parseBoolean(MappingOption.ALWAYS_GENERATE_SERVICE_FILE);
    }

    public boolean isDisableBuilders() {
        return this.parseBoolean(MappingOption.DISABLE_BUILDERS);
    }

    public boolean isVerbose() {
        return this.parseBoolean(MappingOption.VERBOSE);
    }

    public NullValueMappingStrategyGem getNullValueIterableMappingStrategy() {
        return this.parseEnum(MappingOption.NULL_VALUE_ITERABLE_MAPPING_STRATEGY, NullValueMappingStrategyGem.class);
    }

    public NullValueMappingStrategyGem getNullValueMapMappingStrategy() {
        return this.parseEnum(MappingOption.NULL_VALUE_MAP_MAPPING_STRATEGY, NullValueMappingStrategyGem.class);
    }

    public boolean isDisableLifecycleOverloadDeduplicateSelector() {
        return this.parseBoolean(MappingOption.DISABLE_LIFECYCLE_OVERLOAD_DEDUPLICATE_SELECTOR);
    }

    private boolean parseBoolean(MappingOption option) {
        if (this.options.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.options.get(option.getOptionName()));
    }

    private <E extends Enum<E>> E parseEnum(MappingOption option, Class<E> enumType) {
        if (this.options.isEmpty()) {
            return null;
        }
        String value = this.options.get(option.getOptionName());
        if (value == null) {
            return null;
        }
        return Enum.valueOf(enumType, value.toUpperCase(Locale.ROOT));
    }
}

