/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.SelectionParameters;

public class SelectionCriteria {
    private final QualifyingInfo qualifyingInfo;
    private final String targetPropertyName;
    private final SourceRHS sourceRHS;
    private boolean ignoreQualifiers = false;
    private Type type;
    private final MappingControl mappingControl;

    public SelectionCriteria(SelectionParameters selectionParameters, MappingControl mappingControl, String targetPropertyName, Type type) {
        this(QualifyingInfo.fromSelectionParameters(selectionParameters), selectionParameters != null ? selectionParameters.getSourceRHS() : null, mappingControl, targetPropertyName, type);
    }

    private SelectionCriteria(QualifyingInfo qualifyingInfo, SourceRHS sourceRHS, MappingControl mappingControl, String targetPropertyName, Type type) {
        this.qualifyingInfo = qualifyingInfo;
        this.targetPropertyName = targetPropertyName;
        this.sourceRHS = sourceRHS;
        this.type = type;
        this.mappingControl = mappingControl;
    }

    public boolean isForMapping() {
        return this.type == null || this.type == Type.PREFER_UPDATE_MAPPING;
    }

    public boolean isObjectFactoryRequired() {
        return this.type == Type.OBJECT_FACTORY;
    }

    public boolean isLifecycleCallbackRequired() {
        return this.type == Type.LIFECYCLE_CALLBACK;
    }

    public boolean isPresenceCheckRequired() {
        return this.type == Type.PRESENCE_CHECK;
    }

    public boolean isSourceParameterCheckRequired() {
        return this.type == Type.SOURCE_PARAMETER_CHECK;
    }

    public void setIgnoreQualifiers(boolean ignoreQualifiers) {
        this.ignoreQualifiers = ignoreQualifiers;
    }

    public List<TypeMirror> getQualifiers() {
        return this.ignoreQualifiers ? Collections.emptyList() : this.qualifyingInfo.qualifiers();
    }

    public List<String> getQualifiedByNames() {
        return this.ignoreQualifiers ? Collections.emptyList() : this.qualifyingInfo.qualifiedByNames();
    }

    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    public TypeMirror getQualifyingResultType() {
        return this.qualifyingInfo.qualifyingResultType();
    }

    public boolean isPreferUpdateMapping() {
        return this.type == Type.PREFER_UPDATE_MAPPING;
    }

    public SourceRHS getSourceRHS() {
        return this.sourceRHS;
    }

    public void setPreferUpdateMapping(boolean preferUpdateMapping) {
        this.type = preferUpdateMapping ? Type.PREFER_UPDATE_MAPPING : null;
    }

    public boolean hasQualfiers() {
        return !this.qualifyingInfo.qualifiedByNames().isEmpty() || !this.qualifyingInfo.qualifiers().isEmpty();
    }

    public boolean isAllowDirect() {
        return this.mappingControl == null || this.mappingControl.allowDirect();
    }

    public boolean isAllowConversion() {
        return this.mappingControl == null || this.mappingControl.allowTypeConversion();
    }

    public boolean isAllowMappingMethod() {
        return this.mappingControl == null || this.mappingControl.allowMappingMethod();
    }

    public boolean isAllow2Steps() {
        return this.mappingControl == null || this.mappingControl.allowBy2Steps();
    }

    public boolean isSelfAllowed() {
        return this.type != Type.SELF_NOT_ALLOWED;
    }

    public static SelectionCriteria forMappingMethods(SelectionParameters selectionParameters, MappingControl mappingControl, String targetPropertyName, boolean preferUpdateMapping) {
        return new SelectionCriteria(selectionParameters, mappingControl, targetPropertyName, preferUpdateMapping ? Type.PREFER_UPDATE_MAPPING : null);
    }

    public static SelectionCriteria forFactoryMethods(SelectionParameters selectionParameters) {
        return new SelectionCriteria(selectionParameters, null, null, Type.OBJECT_FACTORY);
    }

    public static SelectionCriteria forLifecycleMethods(SelectionParameters selectionParameters) {
        return new SelectionCriteria(selectionParameters, null, null, Type.LIFECYCLE_CALLBACK);
    }

    public static SelectionCriteria forPresenceCheckMethods(SelectionParameters selectionParameters) {
        SourceRHS sourceRHS = selectionParameters.getSourceRHS();
        QualifyingInfo qualifyingInfo = new QualifyingInfo(selectionParameters.getConditionQualifiers(), selectionParameters.getConditionQualifyingNames(), selectionParameters.getResultType());
        Type type = sourceRHS != null && sourceRHS.isSourceReferenceParameter() ? Type.SOURCE_PARAMETER_CHECK : Type.PRESENCE_CHECK;
        return new SelectionCriteria(qualifyingInfo, sourceRHS, null, null, type);
    }

    public static SelectionCriteria forSourceParameterCheckMethods(SelectionParameters selectionParameters) {
        return new SelectionCriteria(selectionParameters, null, null, Type.SOURCE_PARAMETER_CHECK);
    }

    public static SelectionCriteria forSubclassMappingMethods(SelectionParameters selectionParameters, MappingControl mappingControl) {
        return new SelectionCriteria(selectionParameters, mappingControl, null, Type.SELF_NOT_ALLOWED);
    }

    private static class QualifyingInfo {
        private static final QualifyingInfo EMPTY = new QualifyingInfo(Collections.emptyList(), Collections.emptyList(), null);
        private final List<TypeMirror> qualifiers;
        private final List<String> qualifiedByNames;
        private final TypeMirror qualifyingResultType;

        private QualifyingInfo(List<TypeMirror> qualifiers, List<String> qualifiedByNames, TypeMirror qualifyingResultType) {
            this.qualifiers = qualifiers;
            this.qualifiedByNames = qualifiedByNames;
            this.qualifyingResultType = qualifyingResultType;
        }

        public List<TypeMirror> qualifiers() {
            return this.qualifiers;
        }

        public List<String> qualifiedByNames() {
            return this.qualifiedByNames;
        }

        public TypeMirror qualifyingResultType() {
            return this.qualifyingResultType;
        }

        private static QualifyingInfo fromSelectionParameters(SelectionParameters selectionParameters) {
            if (selectionParameters == null) {
                return EMPTY;
            }
            return new QualifyingInfo(selectionParameters.getQualifiers(), selectionParameters.getQualifyingNames(), selectionParameters.getResultType());
        }
    }

    public static enum Type {
        PREFER_UPDATE_MAPPING,
        OBJECT_FACTORY,
        LIFECYCLE_CALLBACK,
        PRESENCE_CHECK,
        SOURCE_PARAMETER_CHECK,
        SELF_NOT_ALLOWED;

    }
}

