/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionContext;

public class LifecycleOverloadDeduplicateSelector
implements MethodSelector {
    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(List<SelectedMethod<T>> methods, SelectionContext context) {
        if (!context.getSelectionCriteria().isLifecycleCallbackRequired() || methods.size() <= 1) {
            return methods;
        }
        Collection methodSignatureGroups = methods.stream().collect(Collectors.groupingBy(LifecycleOverloadDeduplicateSelector::buildSignatureKey, LinkedHashMap::new, Collectors.toList())).values();
        ArrayList<SelectedMethod<T>> deduplicatedMethods = new ArrayList<SelectedMethod<T>>(methods.size());
        for (List signatureGroup : methodSignatureGroups) {
            if (signatureGroup.size() == 1) {
                deduplicatedMethods.add((SelectedMethod)signatureGroup.get(0));
                continue;
            }
            SelectedMethod bestInheritanceMethod = (SelectedMethod)signatureGroup.get(0);
            for (int i = 1; i < signatureGroup.size(); ++i) {
                SelectedMethod candidateMethod = (SelectedMethod)signatureGroup.get(i);
                if (!this.isInheritanceBetter(candidateMethod, bestInheritanceMethod)) continue;
                bestInheritanceMethod = candidateMethod;
            }
            deduplicatedMethods.add(bestInheritanceMethod);
        }
        return deduplicatedMethods;
    }

    private static <T extends Method> List<Object> buildSignatureKey(SelectedMethod<T> method) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(method.getMethod().getDefiningType());
        key.add(method.getMethod().getName());
        for (ParameterBinding binding : method.getParameterBindings()) {
            key.add(binding.getType());
            key.add(binding.getVariableName());
        }
        return key;
    }

    private <T extends Method> boolean isInheritanceBetter(SelectedMethod<T> candidateMethod, SelectedMethod<T> currentBestMethod) {
        List<ParameterBinding> candidateBindings = candidateMethod.getParameterBindings();
        List<ParameterBinding> bestBindings = currentBestMethod.getParameterBindings();
        List<Parameter> candidateParams = candidateMethod.getMethod().getParameters();
        List<Parameter> bestParams = currentBestMethod.getMethod().getParameters();
        int paramCount = candidateBindings.size();
        for (int i = 0; i < paramCount; ++i) {
            int bestDistance;
            int candidateDistance = candidateBindings.get(i).getType().distanceTo(candidateParams.get(i).getType());
            if (candidateDistance < (bestDistance = bestBindings.get(i).getType().distanceTo(bestParams.get(i).getType()))) {
                return true;
            }
            if (candidateDistance <= bestDistance) continue;
            return false;
        }
        return false;
    }
}

